/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.CoreException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FileUtils {
    public static void fileCopy(File src, File dest, boolean overwrite) throws IOException {
        if (!dest.exists() || dest.exists() && overwrite) {
            FileUtils.mkParentDirs(dest);
            if (overwrite) {
                Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(src.toPath(), dest.toPath(), new CopyOption[0]);
            }
        }
    }

    public static void copyFileStreams(File fromFile, File toFile) throws IOException {
        if (!fromFile.exists()) {
            return;
        }
        Files.copy(fromFile.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteDirOnExit(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.deleteDirOnExit(new File(dir, children[i]));
            }
        }
        dir.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileRename(File file, String newPath, Class clazz) {
        File newDestFile = new File(newPath);
        File lockFile = new File(newDestFile.getAbsolutePath() + ".lock");
        try {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
                FileLock lock = channel.lock();
                try {
                    try {
                        FileUtils.mkParentDirs(newDestFile);
                        Files.move(file.toPath(), newDestFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ioe) {
                        throw new CoreException("Unable to move file " + file + " to destination " + newDestFile + ": " + ioe.getMessage());
                    }
                }
                finally {
                    lock.release();
                    channel.close();
                }
            }
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
            e.printStackTrace(System.err);
            throw new CoreException("Unable to rename file: " + e.getMessage(), e);
        }
    }

    public static void fileRename(File file, String newPath) {
        FileUtils.fileRename(file, newPath, FileUtils.class);
    }

    public static void mkParentDirs(File file) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            parentFile = file.getAbsoluteFile().getParentFile();
        }
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create parent directory structure for file " + file.getAbsolutePath());
        }
    }

    public static File getBaseDir(List<File> files) {
        String common = FileUtils.getCommonPrefix(files.stream().map(new Function<File, String>(){

            @Override
            public String apply(File file) {
                return file.getAbsolutePath();
            }
        }).collect(Collectors.toList()));
        if (null != common) {
            return new File(common);
        }
        return null;
    }

    public static String relativePath(File parent, File child) {
        Path superPath = parent.toPath();
        Path subPath = child.toPath();
        if (!subPath.startsWith(superPath)) {
            throw new IllegalArgumentException("Not a subpath: " + child);
        }
        return superPath.relativize(subPath).toString();
    }

    public static String getCommonPrefix(List<String> files) {
        int minlength = -1;
        String common = null;
        for (String path : files) {
            if (path == null) continue;
            if (minlength < 0) {
                common = path;
                minlength = common.length();
                continue;
            }
            int testlen = Math.min(path.length(), minlength);
            for (int i = 0; i < testlen; ++i) {
                if (path.charAt(i) == common.charAt(i)) continue;
                minlength = i;
                common = path.substring(0, minlength);
                break;
            }
            if (testlen >= minlength) continue;
            minlength = testlen;
            common = path.substring(0, minlength);
        }
        return common;
    }

    public static void copyDirectory(File sourceDir, File newDir) throws IOException {
        File[] srcFiles = sourceDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + sourceDir);
        }
        if (newDir.exists() && !newDir.isDirectory()) {
            throw new IOException("Destination '" + newDir + "' exists but is not a directory");
        }
        if (!newDir.mkdirs() && !newDir.isDirectory()) {
            throw new IOException("Destination '" + newDir + "' directory cannot be created");
        }
        if (!newDir.canWrite()) {
            throw new IOException("Destination '" + newDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(newDir, srcFile.getName());
            if (srcFile.isDirectory()) {
                FileUtils.copyDirectory(srcFile, dstFile);
                continue;
            }
            FileUtils.copyFileStreams(srcFile, dstFile);
        }
    }
}

