/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.common;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.DefaultFileCopierUtil;
import com.dtolabs.rundeck.core.execution.impl.common.FileCopierUtil;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class BaseFileCopier {
    public static final String FILE_COPY_DESTINATION_DIR = "file-copy-destination-dir";
    public static final String FRAMEWORK_FILE_COPY_DESTINATION_DIR = "framework.file-copy-destination-dir";
    public static final String PROJECT_FILE_COPY_DESTINATION_DIR = "project.file-copy-destination-dir";
    public static final String DEFAULT_WINDOWS_FILE_EXT = ".bat";
    public static final String DEFAULT_UNIX_FILE_EXT = ".sh";
    private static FileCopierUtil util = new DefaultFileCopierUtil();
    private static AtomicLong counter = new AtomicLong(0L);

    public static String defaultRemoteFileExtensionForNode(INodeEntry node) {
        if (null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim())) {
            return DEFAULT_WINDOWS_FILE_EXT;
        }
        return DEFAULT_UNIX_FILE_EXT;
    }

    public static String appendRemoteFileExtension(String filepath, String fileext) {
        return util.appendRemoteFileExtension(filepath, fileext);
    }

    public static String getRemoteDirForNode(INodeEntry node) {
        return util.getRemoteDirForNode(node);
    }

    public static String getRemoteDirForNode(INodeEntry node, IRundeckProject project, IFramework framework) {
        return util.getRemoteDirForNode(node, project, framework);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName) {
        return BaseFileCopier.generateRemoteFilepathForNode(node, scriptfileName, null);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName, String fileExtension) {
        return BaseFileCopier.generateRemoteFilepathForNode(node, scriptfileName, fileExtension, null);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName, String fileExtension, String identity) {
        return BaseFileCopier.generateRemoteFilepathForNode(node, null, null, scriptfileName, fileExtension, identity);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, IRundeckProject project, IFramework framework, String scriptfileName, String fileExtension, String identity) {
        return util.generateRemoteFilepathForNode(node, project, framework, scriptfileName, fileExtension, identity);
    }

    public static File writeTempFile(ExecutionContext context, File original, InputStream input, String script) throws FileCopierException {
        return util.writeTempFile(context, original, input, script);
    }

    protected static File writeLocalFile(File original, InputStream input, String script, File destinationFile) throws FileCopierException {
        return util.writeLocalFile(original, input, script, destinationFile);
    }
}

