/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.execution.workflow.ContextStack;
import com.dtolabs.rundeck.core.execution.workflow.StepNodeContext;
import com.dtolabs.rundeck.core.execution.workflow.StepNodeContextListener;
import com.dtolabs.rundeck.core.utils.NullablePairImpl;
import com.dtolabs.rundeck.core.utils.Pair;
import com.dtolabs.rundeck.core.utils.Pairs;
import java.util.ArrayList;
import java.util.List;

public class StepContextWorkflowExecutionListener<NODE, STEP>
implements StepNodeContextListener<NODE, STEP>,
StepNodeContext<NODE, STEP> {
    private InheritableThreadLocal<STEP> localStep = new InheritableThreadLocal();
    private InheritableThreadLocal<NODE> localNode = new InheritableThreadLocal();
    private InheritableThreadLocal<ContextStack<ctxPair>> contextStack = new InheritableThreadLocal();

    @Override
    public void beginContext() {
        Object info = this.localStep.get();
        Object node = this.localNode.get();
        if (null != info) {
            ctxPair pair = new ctxPair(info, node);
            if (null != this.contextStack.get()) {
                this.contextStack.set(((ContextStack)this.contextStack.get()).copyPush(pair));
            } else {
                this.contextStack.set(ContextStack.create(pair));
            }
        }
        this.localStep.set(null);
        this.localNode.set(null);
    }

    @Override
    public void finishContext() {
        ContextStack stack = (ContextStack)this.contextStack.get();
        if (null != stack) {
            if (stack.size() > 0) {
                ctxPair pop = (ctxPair)stack.pop();
                this.localStep.set(pop.getFirst());
                this.localNode.set(pop.getSecond());
            } else {
                this.localStep.set(null);
                this.localNode.set(null);
                this.contextStack.set(null);
            }
        } else {
            this.localStep.set(null);
            this.localNode.set(null);
        }
    }

    @Override
    public void beginStepContext(STEP step) {
        this.localStep.set(step);
    }

    @Override
    public void finishStepContext() {
        this.localStep.set(null);
    }

    @Override
    public void beginNodeContext(NODE node) {
        this.localNode.set(node);
    }

    @Override
    public void finishNodeContext() {
        this.localNode.set(null);
    }

    public STEP getCurrentStep() {
        return (STEP)this.localStep.get();
    }

    @Override
    public NODE getCurrentNode() {
        return (NODE)this.localNode.get();
    }

    @Override
    public List<STEP> getCurrentContext() {
        List currentContextPairs = this.getCurrentContextPairs();
        if (null != currentContextPairs) {
            return Pairs.listFirst(currentContextPairs);
        }
        return null;
    }

    public List<Pair<STEP, NODE>> getCurrentContextPairs() {
        Object step = this.localStep.get();
        Object node = this.localNode.get();
        if (null != step) {
            if (null != this.contextStack.get()) {
                return this.getPairs(((ContextStack)this.contextStack.get()).copyPush(new ctxPair(step, node)).stack());
            }
            return this.getPairs(ContextStack.create(new ctxPair(step, node)).stack());
        }
        if (null != this.contextStack.get()) {
            List<Pair<STEP, NODE>> stack = this.getPairs(((ContextStack)this.contextStack.get()).stack());
            if (stack.size() > 0) {
                return stack;
            }
            return null;
        }
        return null;
    }

    private List<Pair<STEP, NODE>> getPairs(List<ctxPair> stack) {
        ArrayList<Pair<STEP, NODE>> pairs = new ArrayList<Pair<STEP, NODE>>();
        for (ctxPair ctxPair2 : stack) {
            pairs.add(ctxPair2);
        }
        return pairs;
    }

    public class ctxPair
    extends NullablePairImpl<STEP, NODE>
    implements Pair<STEP, NODE> {
        ctxPair(STEP first, NODE second) {
            super(first, second);
        }
    }
}

