/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.acl;

import com.dtolabs.rundeck.core.authorization.RuleSetValidation;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.rundeck.app.acl.ACLFileManager;
import org.rundeck.app.acl.ACLFileManagerListener;
import org.rundeck.app.acl.AclPolicyFile;
import org.rundeck.app.acl.ContextACLManager;

public abstract class BaseContextACLManager<T>
implements ContextACLManager<T> {
    private final List<Function<T, ACLFileManagerListener>> listenerMappings = Collections.synchronizedList(new ArrayList());
    private final Map<T, ACLFileManager> contextManagers = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ACLFileManager applyMappings(T ctx, ACLFileManager listenable) {
        List<Function<T, ACLFileManagerListener>> list = this.listenerMappings;
        synchronized (list) {
            this.listenerMappings.forEach(f -> {
                ACLFileManagerListener l = (ACLFileManagerListener)f.apply(ctx);
                if (l != null) {
                    listenable.addListener(l);
                }
            });
        }
        return listenable;
    }

    protected abstract ACLFileManager createManager(T var1);

    private ACLFileManager createWithMappings(T context) {
        return this.applyMappings(context, this.createManager(context));
    }

    @Override
    public ACLFileManager forContext(T context) {
        return this.contextManagers.computeIfAbsent(context, this::createWithMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListenerMap(Function<T, ACLFileManagerListener> mapping) {
        Map<T, ACLFileManager> map = this.contextManagers;
        synchronized (map) {
            this.contextManagers.forEach((k, m) -> m.addListener((ACLFileManagerListener)mapping.apply(k)));
            this.listenerMappings.add(mapping);
        }
    }

    @Override
    public void addListener(T context, ACLFileManagerListener listener) {
        this.forContext(context).addListener(listener);
    }

    @Override
    public void removeListener(T context, ACLFileManagerListener listener) {
        this.forContext(context).removeListener(listener);
    }

    @Override
    public long storePolicyFile(T context, String fileName, InputStream input) throws IOException {
        return this.forContext(context).storePolicyFile(fileName, input);
    }

    @Override
    public boolean deletePolicyFile(T context, String fileName) throws IOException {
        return this.forContext(context).deletePolicyFile(fileName);
    }

    @Override
    public long storePolicyFileContents(T context, String fileName, String fileText) throws IOException {
        return this.forContext(context).storePolicyFileContents(fileName, fileText);
    }

    @Override
    public AclPolicyFile getAclPolicy(T context, String fileName) {
        return this.forContext(context).getAclPolicy(fileName);
    }

    @Override
    public String getPolicyFileContents(T context, String fileName) throws IOException {
        return this.forContext(context).getPolicyFileContents(fileName);
    }

    @Override
    public long loadPolicyFileContents(T context, String fileName, OutputStream outputStream) throws IOException {
        return this.forContext(context).loadPolicyFileContents(fileName, outputStream);
    }

    @Override
    public boolean existsPolicyFile(T context, String file) {
        return this.forContext(context).existsPolicyFile(file);
    }

    @Override
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(T context, String ident, String text) throws IOException {
        return this.forContext(context).getValidator().validateYamlPolicy(ident, text);
    }

    @Override
    public RuleSetValidation<PolicyCollection> validatePolicyFile(T context, String fname) throws IOException {
        return this.forContext(context).validatePolicyFile(fname);
    }

    @Override
    public List<String> listStoredPolicyFiles(T context) {
        return this.forContext(context).listStoredPolicyFiles();
    }
}

