/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageTreeImpl;
import com.dtolabs.rundeck.core.storage.TypedStorageTree;
import com.dtolabs.rundeck.core.storage.WrongContentType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.StorageException;
import org.rundeck.storage.api.Tree;

public class TypedStorageTreeImpl
extends StorageTreeImpl
implements TypedStorageTree {
    public TypedStorageTreeImpl(Tree<ResourceMeta> delegate) {
        super(delegate);
    }

    private static byte[] readBytes(Resource<ResourceMeta> resource) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ResourceMeta)resource.getContents()).writeContent(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public Resource<ResourceMeta> getResourceWithType(Path path, String contentType) {
        Resource resource = this.getResource(path);
        if (((ResourceMeta)resource.getContents()).getContentType().equals(contentType)) {
            return resource;
        }
        throw new WrongContentType("Path ${path} does not store a password, content-type: ${resource.contents.contentType}", StorageException.Event.READ, path);
    }

    @Override
    public boolean hasResourceWithType(Path path, String contentType) {
        boolean exists = this.hasResource(path);
        if (!exists) {
            return false;
        }
        Resource resource = this.getResource(path);
        return ((ResourceMeta)resource.getContents()).getContentType().equals(contentType);
    }

    @Override
    public byte[] readResourceWithType(Path path, String contentType) throws IOException {
        return TypedStorageTreeImpl.readBytes(this.getResourceWithType(path, contentType));
    }
}

