/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.local;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.impl.common.AntSupport;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGenerator;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGeneratorImpl;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameters;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.plugins.descriptions.PluginDescription;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.RedirectorElement;

@Plugin(name="local", service="NodeExecutor")
@PluginDescription(title="Local", description="Executes commands locally on the Rundeck server")
public class LocalNodeExecutor
implements NodeExecutor {
    public static final String SERVICE_PROVIDER_TYPE = "local";
    public static final String DISABLE_LOCAL_EXECUTOR_ENV = "DISABLED_LOCAL_EXECUTOR";
    public static final String DISABLE_LOCAL_EXECUTOR_PROP = "rundeck.localExecutor.disabled";
    private Framework framework;
    private ExecTaskParameterGenerator parameterGenerator;
    private boolean disableLocalExecutor = false;

    public LocalNodeExecutor(Framework framework) {
        this.framework = framework;
        this.parameterGenerator = new ExecTaskParameterGeneratorImpl();
        this.disableLocalExecutor = LocalNodeExecutor.getDisableLocalExecutorEnv();
    }

    static Boolean getDisableLocalExecutorEnv() {
        String disableLocalExecutor = System.getenv(DISABLE_LOCAL_EXECUTOR_ENV);
        if (disableLocalExecutor != null && disableLocalExecutor.equals("true")) {
            return true;
        }
        return Boolean.getBoolean(DISABLE_LOCAL_EXECUTOR_PROP);
    }

    public void setDisableLocalExecutor(boolean disableLocalExecutor) {
        this.disableLocalExecutor = disableLocalExecutor;
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) {
        boolean status;
        int result;
        ExecTask execTask;
        if (this.disableLocalExecutor) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, "Local Executor is disabled", node);
        }
        ExecutionListener listener = context.getExecutionListener();
        Project project = new Project();
        AntSupport.addAntBuildListener(listener, project);
        String propName = System.currentTimeMillis() + ".node." + node.getNodename() + ".LocalNodeExecutor.result";
        listener.log(3, "using charset: " + context.getCharsetEncoding());
        boolean success = false;
        try {
            execTask = LocalNodeExecutor.buildExecTask(project, this.parameterGenerator.generate(node, true, null, command), context.getDataContext(), context.getCharsetEncoding(), new ExecTask());
        }
        catch (ExecutionException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, e.getMessage(), node);
        }
        execTask.setResultProperty(propName);
        try {
            execTask.execute();
            success = true;
        }
        catch (BuildException e) {
            context.getExecutionListener().log(0, e.getMessage());
        }
        int n = result = success ? 0 : -1;
        if (project.getProperty(propName) != null) {
            try {
                result = Integer.parseInt(project.getProperty(propName));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (null != context.getOutputContext()) {
            context.getOutputContext().addOutput("exec", "exitCode", String.valueOf(result));
        }
        boolean bl = status = 0 == result;
        if (status) {
            return NodeExecutorResultImpl.createSuccess(node);
        }
        return NodeExecutorResultImpl.createFailure(NodeStepFailureReason.NonZeroResultCode, "Result code was " + result, node, result);
    }

    public static ExecTask buildExecTask(Project project, ExecTaskParameters taskParameters, Map<String, Map<String, String>> dataContext, String charset, ExecTask task) {
        ExecTask execTask = task;
        execTask.setTaskType("exec");
        execTask.setFailonerror(false);
        execTask.setProject(project);
        execTask.setExecutable(taskParameters.getCommandexecutable());
        String[] commandargs = taskParameters.getCommandArgs();
        if (null != commandargs) {
            for (String commandarg : commandargs) {
                execTask.createArg().setValue(commandarg);
            }
        }
        DataContextUtils.addEnvVarsFromContextForExec(execTask, dataContext);
        if (charset != null) {
            RedirectorElement redirectorElement = new RedirectorElement();
            redirectorElement.setInputEncoding(charset);
            execTask.addConfiguredRedirector(redirectorElement);
        }
        return execTask;
    }
}

