/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging;

import com.dtolabs.rundeck.core.execution.workflow.ContextStack;
import com.dtolabs.rundeck.core.logging.FilterStreamingLogWriter;
import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.StreamingLogWriter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class OverridableStreamingLogWriter
extends FilterStreamingLogWriter {
    private final InheritableThreadLocal<ContextStack<Optional<StreamingLogWriter>>> override = new InheritableThreadLocal<ContextStack<Optional<StreamingLogWriter>>>(){

        @Override
        protected ContextStack<Optional<StreamingLogWriter>> initialValue() {
            return new ContextStack<Optional<StreamingLogWriter>>();
        }

        @Override
        protected ContextStack<Optional<StreamingLogWriter>> childValue(ContextStack<Optional<StreamingLogWriter>> parentValue) {
            return new ContextStack<List<Optional<StreamingLogWriter>>>(parentValue.stack());
        }
    };

    public OverridableStreamingLogWriter(StreamingLogWriter writer) {
        super(writer);
    }

    @Override
    public void openStream() throws IOException {
        if (this.getOverride() != null) {
            this.getOverride().openStream();
            return;
        }
        super.openStream();
    }

    @Override
    public void addEvent(LogEvent event) {
        if (this.getOverride() != null) {
            this.getOverride().addEvent(event);
            return;
        }
        super.addEvent(event);
    }

    @Override
    public void close() {
        if (this.getOverride() != null) {
            this.getOverride().close();
            return;
        }
        super.close();
    }

    public StreamingLogWriter getOverride() {
        if (((ContextStack)this.override.get()).size() > 0) {
            return ((Optional)((ContextStack)this.override.get()).peek()).orElse(null);
        }
        return null;
    }

    public void setOverride(StreamingLogWriter writer) {
        ((ContextStack)this.override.get()).push(Optional.ofNullable(writer));
    }

    public void pushEmpty() {
        this.setOverride(null);
    }

    public StreamingLogWriter removeOverride() {
        StreamingLogWriter previous = ((Optional)((ContextStack)this.override.get()).pop()).orElse(null);
        return previous;
    }
}

