/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.local;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.impl.local.LocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import java.io.File;
import java.io.InputStream;

public class LocalFileCopier
extends BaseFileCopier
implements FileCopier {
    public static final String SERVICE_PROVIDER_TYPE = "local";
    private boolean disableLocalExecutor = false;
    private Framework framework;

    public LocalFileCopier(Framework framework) {
        this.framework = framework;
        this.disableLocalExecutor = LocalNodeExecutor.getDisableLocalExecutorEnv();
    }

    public void setDisableLocalExecutor(boolean disableLocalExecutor) {
        this.disableLocalExecutor = disableLocalExecutor;
    }

    private String copyFile(ExecutionContext context, File scriptfile, InputStream input, String script, INodeEntry node, String destination) throws FileCopierException {
        if (this.disableLocalExecutor) {
            throw new FileCopierException("Local Executor is disabled", StepFailureReason.ConfigurationFailure);
        }
        return BaseFileCopier.writeLocalFile(scriptfile, input, script, null != destination ? new File(destination) : null).getAbsolutePath();
    }

    @Override
    public String copyFileStream(ExecutionContext context, InputStream input, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(context, null, input, null, node, destination);
    }

    @Override
    public String copyFile(ExecutionContext context, File file, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(context, file, null, null, node, destination);
    }

    @Override
    public String copyScriptContent(ExecutionContext context, String script, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(context, null, null, script, node, destination);
    }
}

