/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.PluginDirChangeEvent;
import com.dtolabs.rundeck.core.plugins.PluginDirChangeEventListener;
import com.dtolabs.rundeck.core.plugins.PluginDirChangeType;
import com.dtolabs.rundeck.core.plugins.PluginDirProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class WatchingPluginDirProvider
implements PluginDirProvider {
    private final File pluginDir;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final List<PluginDirChangeEventListener> changeEventListeners = new ArrayList<PluginDirChangeEventListener>();

    public WatchingPluginDirProvider(File pluginDir) {
        this.pluginDir = pluginDir;
        if (!this.pluginDir.exists()) {
            this.pluginDir.mkdirs();
        }
        this.startFolderWatch();
    }

    void startFolderWatch() {
        this.executor.execute(() -> {
            try {
                WatchService watcher = FileSystems.getDefault().newWatchService();
                Path dir = this.pluginDir.toPath();
                try {
                    WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    while (!this.executor.isShutdown()) {
                        WatchKey tkey;
                        try {
                            tkey = watcher.take();
                        }
                        catch (InterruptedException iex) {
                            System.out.println("plugin dir watcher was interrupted");
                            return;
                        }
                        for (WatchEvent<?> evt : tkey.pollEvents()) {
                            String fileName;
                            WatchEvent.Kind<?> kind = evt.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW || !(fileName = evt.context().toString()).endsWith(".jar") && !fileName.endsWith(".zip")) continue;
                            PluginDirChangeEvent event = new PluginDirChangeEvent(fileName, PluginDirChangeType.convertFromWatchKind(kind));
                            for (PluginDirChangeEventListener listener : this.changeEventListeners) {
                                listener.onDirChangeEvent(event);
                            }
                        }
                        if (key.reset()) continue;
                    }
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to start plugin dir watcher");
                e.printStackTrace();
            }
        });
    }

    @Override
    public File getPluginDir() {
        return this.pluginDir;
    }

    @Override
    public void registerDirChangeEventListener(PluginDirChangeEventListener changeEventListener) {
        this.changeEventListeners.add(changeEventListener);
    }
}

