/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.webhook;

import com.dtolabs.rundeck.plugins.webhook.DefaultWebhookResponder;
import com.dtolabs.rundeck.plugins.webhook.WebhookResponder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonWebhookResponder
implements WebhookResponder {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWebhookResponder.class);
    private final Map<String, Object> responsePayload;

    public DefaultJsonWebhookResponder(Map<String, Object> responsePayload) {
        this.responsePayload = responsePayload;
    }

    @Override
    public void respond(HttpServletResponse response) {
        try {
            response.setContentType("application/json; charset=UTF-8");
            mapper.writeValue((OutputStream)response.getOutputStream(), this.responsePayload);
        }
        catch (Exception ex) {
            LOG.error("Unable to write webhook response", (Throwable)ex);
        }
    }
}

