/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetAuthorization;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Decision;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuthorization
implements AclRuleSetAuthorization {
    private static Logger logger = LoggerFactory.getLogger(LoggingAuthorization.class);
    private AclRuleSetAuthorization authorization;

    public LoggingAuthorization(AclRuleSetAuthorization authorization) {
        this.authorization = authorization;
    }

    public AclRuleSet getRuleSet() {
        return this.authorization.getRuleSet();
    }

    public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        Decision decision = this.getAuthorization().evaluate(resource, subject, action, environment);
        if (decision.isAuthorized()) {
            logger.info(MessageFormat.format("Evaluating {0} ({1}ms)", decision, decision.evaluationDuration()));
        } else {
            logger.warn(MessageFormat.format("Evaluating {0} ({1}ms)", decision, decision.evaluationDuration()));
        }
        return decision;
    }

    public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> actions, Set<Attribute> environment) {
        Set decisions = this.getAuthorization().evaluate(resources, subject, actions, environment);
        boolean anyAuthorized = false;
        for (Decision decision : decisions) {
            if (!decision.isAuthorized()) continue;
            anyAuthorized = true;
        }
        for (Decision decision : decisions) {
            if (!anyAuthorized) {
                logger.warn(MessageFormat.format("Evaluating {0} ({1}ms)", decision, decision.evaluationDuration()));
                continue;
            }
            logger.info(MessageFormat.format("Evaluating {0} ({1}ms)", decision, decision.evaluationDuration()));
        }
        return decisions;
    }

    public AclRuleSetAuthorization getAuthorization() {
        return this.authorization;
    }
}

