/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.data;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.data.ViewTraverse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class MultiDataContextImpl<K extends ViewTraverse<K>, D extends DataContext>
implements MultiDataContext<K, D> {
    Map<K, D> map;
    private MultiDataContext<K, D> base;

    public MultiDataContextImpl(Map<K, D> map) {
        this.map = map;
    }

    public MultiDataContextImpl() {
        this(new HashMap());
    }

    public MultiDataContextImpl(MultiDataContext<K, D> orig) {
        this(new HashMap());
        this.base = orig;
    }

    @Override
    public Map<K, D> getData() {
        return this.map;
    }

    @Override
    public D getData(K key) {
        return (D)((DataContext)this.map.get(key));
    }

    @Override
    public Set<K> getKeys() {
        return this.map.keySet();
    }

    @Override
    public Set<K> getConsolidatedKeys() {
        HashSet<K> ks = new HashSet<K>();
        if (this.getBase() != null) {
            ks.addAll(this.getBase().getConsolidatedKeys());
        }
        ks.addAll(this.getKeys());
        return ks;
    }

    @Override
    public MultiDataContext<K, D> getBase() {
        return this.base;
    }

    @Override
    public void merge(K k, D data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (!this.map.containsKey(k)) {
            this.map.put(k, this.newData());
        }
        ((DataContext)this.map.get(k)).merge(data);
    }

    protected abstract D newData();

    protected void setBase(MultiDataContext<K, D> base) {
        this.base = base;
    }

    @Override
    public void merge(MultiDataContext<K, D> input) {
        if (null == input) {
            return;
        }
        for (ViewTraverse k : input.getData().keySet()) {
            DataContext data = (DataContext)input.getData().get(k);
            if (null == data) continue;
            this.merge(k, data);
        }
    }

    public String toString() {
        return "MultiDataContextImpl(map=" + this.map + ", base=" + this.getBase() + ")";
    }
}

