/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.Contextual;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.NoopWorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepContextWorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.state.StateUtils;
import com.dtolabs.rundeck.core.execution.workflow.state.StepContextId;
import com.dtolabs.rundeck.core.execution.workflow.state.StepIdentifier;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextManager
extends NoopWorkflowExecutionListener
implements Contextual,
WorkflowExecutionListener {
    private StepContextWorkflowExecutionListener<INodeEntry, StepContextId> stepContext = new StepContextWorkflowExecutionListener();

    @Override
    public void beginExecuteNodeStep(ExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        this.stepContext.beginNodeContext(node);
    }

    @Override
    public void finishExecuteNodeStep(NodeStepResult result, ExecutionContext context, StepExecutionItem item, INodeEntry node) {
        this.stepContext.finishNodeContext();
    }

    @Override
    public Map<String, String> getContext() {
        INodeEntry currentNode = this.stepContext.getCurrentNode();
        List<Pair<StepContextId, INodeEntry>> currentContext = this.stepContext.getCurrentContextPairs();
        if (null != currentContext || null != currentNode) {
            HashMap<String, String> loggingContext = new HashMap<String, String>();
            if (null != currentNode) {
                loggingContext.put("node", currentNode.getNodename());
                loggingContext.put("user", currentNode.extractUserName());
            }
            if (null != currentContext) {
                StepContextId last = currentContext.get(currentContext.size() - 1).getFirst();
                if (last.getStep() > -1) {
                    loggingContext.put("step", Integer.toString(last.getStep()));
                }
                loggingContext.put("stepctx", StateUtils.stepIdentifierToString(this.generateIdentifier(currentContext)));
            }
            return loggingContext;
        }
        return null;
    }

    private StepIdentifier generateIdentifier(List<Pair<StepContextId, INodeEntry>> stack) {
        ArrayList<StepContextId> ctxs = new ArrayList<StepContextId>();
        int i = 0;
        for (Pair<StepContextId, INodeEntry> pair : stack) {
            HashMap<String, String> params = null;
            if (null != pair.getSecond() && i < stack.size() - 1) {
                params = new HashMap<String, String>();
                params.put("node", pair.getSecond().getNodename());
            }
            ctxs.add(StateUtils.stepContextId(pair.getFirst().getStep(), !pair.getFirst().getAspect().isMain(), params));
            ++i;
        }
        return StateUtils.stepIdentifier(ctxs);
    }

    @Override
    public void beginWorkflowExecution(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        this.stepContext.beginContext();
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, StepExecutionContext executionContext, WorkflowExecutionItem item) {
        this.stepContext.finishContext();
    }

    @Override
    public void beginWorkflowItem(int step, StepExecutionItem item) {
        this.stepContext.beginStepContext(StateUtils.stepContextId(step, false));
    }

    @Override
    public void beginWorkflowItemErrorHandler(int step, StepExecutionItem item) {
        this.stepContext.beginStepContext(StateUtils.stepContextId(step, true));
    }

    @Override
    public void finishWorkflowItem(int step, StepExecutionItem item, StepExecutionResult result) {
        this.stepContext.finishStepContext();
    }

    @Override
    public void finishWorkflowItemErrorHandler(int step, StepExecutionItem item, StepExecutionResult result) {
        this.stepContext.beginStepContext(StateUtils.stepContextId(step, false));
    }
}

