/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import java.util.Date;
import java.util.Map;

abstract class BaseResource
implements ResourceMeta {
    Map<String, String> meta;

    protected BaseResource(Map<String, String> meta) {
        this.meta = meta;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    @Override
    public String getContentType() {
        return this.meta.get("Rundeck-content-type");
    }

    @Override
    public long getContentLength() {
        return StorageUtil.parseLong(this.meta.get("Rundeck-content-size"), -1L);
    }

    @Override
    public Date getModificationTime() {
        return StorageUtil.parseDate(this.meta.get("Rundeck-content-modify-time"), null);
    }

    @Override
    public Date getCreationTime() {
        return StorageUtil.parseDate(this.meta.get("Rundeck-content-creation-time"), null);
    }
}

