/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.http;

import com.dtolabs.rundeck.core.http.HttpClient;
import com.dtolabs.rundeck.core.http.RequestProcessor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpClient
implements HttpClient<HttpResponse> {
    HttpClientBuilder clientBuilder = HttpClients.custom();
    RequestConfig.Builder rqConfigBuilder = RequestConfig.custom();
    HttpClientContext clientContext = null;
    HttpRequestBase request = null;
    URI uri;
    Map<String, String> headers = new HashMap<String, String>();

    @Override
    public HttpClient<HttpResponse> setUri(URI uri) {
        this.uri = uri;
        this.request = new HttpGet(uri);
        return this;
    }

    @Override
    public HttpClient<HttpResponse> setFollowRedirects(boolean redirects) {
        this.rqConfigBuilder.setRedirectsEnabled(redirects);
        return this;
    }

    @Override
    public HttpClient<HttpResponse> setBasicAuthCredentials(String username, String password) {
        if (this.uri == null) {
            throw new IllegalStateException("The URI must be set first. Please call setUri(yourTargetUri)");
        }
        BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
        credProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort(), AuthScope.ANY_REALM, "BASIC"), (Credentials)new UsernamePasswordCredentials(username, password));
        this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost target = new HttpHost(this.uri.getHost(), this.uri.getPort(), this.uri.getScheme());
        authCache.put(target, (AuthScheme)basicAuth);
        this.clientContext = HttpClientContext.create();
        this.clientContext.setAuthCache((AuthCache)authCache);
        return this;
    }

    @Override
    public HttpClient<HttpResponse> setTimeout(int timeoutMs) {
        this.rqConfigBuilder.setConnectTimeout(timeoutMs).setSocketTimeout(timeoutMs);
        return this;
    }

    @Override
    public HttpClient<HttpResponse> setMethod(HttpClient.Method method) {
        if (this.uri == null) {
            throw new IllegalStateException("The URI must be set first. Please call setUri(yourTargetUri)");
        }
        if (method == HttpClient.Method.GET) {
            this.request = new HttpGet(this.uri);
        } else if (method == HttpClient.Method.POST) {
            this.request = new HttpPost(this.uri);
        } else if (method == HttpClient.Method.PUT) {
            this.request = new HttpPut(this.uri);
        } else {
            throw new UnsupportedOperationException(String.format("Method %s not implemented", method.name()));
        }
        return this;
    }

    @Override
    public HttpClient<HttpResponse> setRetryCount(int count) {
        this.clientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(count, false));
        return this;
    }

    @Override
    public HttpClient<HttpResponse> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    @Override
    public HttpClient<HttpResponse> addPayload(String contentType, String payload) {
        if (this.uri == null) {
            throw new IllegalStateException("The URI must be set first. Please call setUri(yourTargetUri)");
        }
        if (!(this.request instanceof HttpEntityEnclosingRequestBase)) {
            throw new IllegalStateException("Request must be either Post or Put. Make sure to call setMethod(Method.POST | Method.PUT) before attempting to add a payload.");
        }
        ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new StringEntity(payload, ContentType.create((String)contentType, (String)"UTF-8")));
        return this;
    }

    @Override
    public void execute(RequestProcessor<HttpResponse> processor) throws Exception {
        if (this.uri == null) {
            throw new IllegalStateException("The URI must be set before executing the request");
        }
        try (CloseableHttpClient client = this.clientBuilder.setDefaultRequestConfig(this.rqConfigBuilder.build()).build();){
            this.headers.forEach((n, v) -> this.request.addHeader(n, v));
            CloseableHttpResponse rsp = this.clientContext != null ? client.execute((HttpUriRequest)this.request, (HttpContext)this.clientContext) : client.execute((HttpUriRequest)this.request);
            processor.accept((HttpResponse)rsp);
        }
    }
}

