/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.SourceType;
import com.dtolabs.rundeck.core.resources.WriteableModelSource;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public abstract class BaseFileResourceModelSource
implements ResourceModelSource,
WriteableModelSource {
    protected Framework framework;
    protected NodeSetImpl nodeSet = new NodeSetImpl();
    long lastModTime = 0L;

    public BaseFileResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    @Override
    public String getSyntaxMimeType() {
        try {
            return this.getResourceFormatParser().getPreferredMimeType();
        }
        catch (ResourceModelSourceException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ResourceFormatParser getResourceFormatParser() throws ResourceModelSourceException {
        try {
            String format = this.getResourceFormat();
            if (null != format) {
                return this.framework.getResourceFormatParserService().getParserForFormat(format);
            }
            return this.framework.getResourceFormatParserService().getParserForFileExtension(this.getDocumentFileExtension());
        }
        catch (UnsupportedFormatException e) {
            throw new ResourceModelSourceException(e);
        }
    }

    protected abstract String getResourceFormat();

    protected abstract String getDocumentFileExtension();

    /*
     * Loose catch block
     */
    @Override
    public long writeData(InputStream data) throws IOException, ResourceModelSourceException {
        if (!this.isDataWritable()) {
            throw new IllegalArgumentException("Cannot write to file, it is not configured to be writeable");
        }
        ResourceFormatParser resourceFormat = this.getResourceFormatParser();
        File temp = Files.createTempFile("temp", "." + resourceFormat.getPreferredFileExtension(), new FileAttribute[0]).toFile();
        temp.deleteOnExit();
        try {
            FileOutputStream fos = new FileOutputStream(temp);
            Object object = null;
            try {
                Streams.copyStream(data, fos);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fos != null) {
                    if (object != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
            ResourceFormatParser parser = this.getResourceFormatParser();
            try {
                object = parser.parseDocument(temp);
            }
            catch (ResourceFormatParserException e) {
                throw new ResourceModelSourceException(e);
            }
            try (FileInputStream tempStream = new FileInputStream(temp);){
                long l = this.writeFileData(temp.length(), tempStream);
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            temp.delete();
        }
    }

    public abstract long writeFileData(InputStream var1) throws IOException;

    protected long writeFileData(long length, InputStream tempStream) throws IOException {
        return this.writeFileData(tempStream);
    }

    public abstract InputStream openFileDataInputStream() throws IOException, ResourceModelSourceException;

    @Override
    public long readData(OutputStream sink) throws IOException, ResourceModelSourceException {
        if (!this.hasData()) {
            return 0L;
        }
        try (InputStream inputStream = this.openFileDataInputStream();){
            long l = Streams.copyStream(inputStream, sink);
            return l;
        }
    }

    @Override
    public SourceType getSourceType() {
        return this.isDataWritable() ? SourceType.READ_WRITE : SourceType.READ_ONLY;
    }

    public boolean isDataWritable() {
        return false;
    }

    protected boolean shouldGenerateServerNode() {
        return false;
    }

    protected boolean isSupportsLastModified() {
        return false;
    }

    protected long getLastModified() {
        return -1L;
    }

    @Override
    public WriteableModelSource getWriteable() {
        return this.isDataWritable() ? this : null;
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        return this.getNodes(this.getResourceFormatParser());
    }

    public synchronized INodeSet getNodes(ResourceFormatParser parser) throws ResourceModelSourceException {
        Long modtime = this.isSupportsLastModified() ? this.getLastModified() : -1L;
        if (0 == this.nodeSet.getNodes().size() || modtime < 0L || modtime > this.lastModTime) {
            this.nodeSet = this.loadNodes(parser, this.shouldGenerateServerNode());
            this.lastModTime = modtime;
        }
        return this.nodeSet;
    }

    private NodeSetImpl loadNodes(ResourceFormatParser parser, boolean generateServerNode) throws ResourceModelSourceException {
        NodeSetImpl newNodes = new NodeSetImpl();
        if (generateServerNode) {
            NodeEntryImpl node = this.framework.createFrameworkNode();
            newNodes.putNode(node);
        }
        if (this.hasData()) {
            try (InputStream input = this.openFileDataInputStream();){
                INodeSet set = parser.parseDocument(input);
                if (null != set) {
                    newNodes.putNodes(set);
                }
            }
            catch (ResourceFormatParserException | IOException e) {
                throw new ResourceModelSourceException(e);
            }
        }
        return newNodes;
    }
}

