/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.CanSetResourceMeta;
import com.dtolabs.rundeck.core.storage.HasResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ResourceMetaBuilder
implements CanSetResourceMeta,
HasResourceMeta {
    Map<String, String> meta;

    public ResourceMetaBuilder(Map<String, String> meta) {
        if (null != meta) {
            this.meta = meta;
        }
    }

    public ResourceMetaBuilder() {
        this(new HashMap<String, String>());
    }

    @Override
    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    @Override
    public void setMeta(String key, String value) {
        this.meta.put(key, value);
    }

    @Override
    public void setContentType(String value) {
        this.setMeta("Rundeck-content-type", value);
    }

    public String getContentType() {
        return this.getResourceMeta().get("Rundeck-content-type");
    }

    @Override
    public void setContentLength(long length) {
        this.setMeta("Rundeck-content-size", Long.toString(length));
    }

    public long getContentLength() {
        return Long.parseLong(this.getResourceMeta().get("Rundeck-content-size"));
    }

    @Override
    public void setModificationTime(Date time) {
        this.setMeta("Rundeck-content-modify-time", StorageUtil.formatDate(time));
    }

    public Date getModificationTime() {
        String s = this.getResourceMeta().get("Rundeck-content-modify-time");
        if (null != s) {
            return StorageUtil.parseDate(s, null);
        }
        return null;
    }

    @Override
    public void setCreationTime(Date time) {
        this.setMeta("Rundeck-content-creation-time", StorageUtil.formatDate(time));
    }

    public Date getCreationTime() {
        String s = this.getResourceMeta().get("Rundeck-content-creation-time");
        if (null != s) {
            return StorageUtil.parseDate(s, null);
        }
        return null;
    }

    @Override
    public Map<String, String> getResourceMeta() {
        return this.meta;
    }
}

