/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.components.jobs;

import java.util.LinkedHashMap;
import java.util.Map;

public class JobXMLUtil {
    public static final String ATTR_PREFIX = "@attr:";
    public static final String PLURAL_SUFFIX = "[s]";
    public static final String PLURAL_REPL = "s";
    public static final String CDATA_SUFFIX = "<cdata>";
    public static final String DATAVALUE_SUFFIX = "<dataval>";
    public static final String TEXT_KEY = "<text>";

    public static void addAttribute(Map map, String key, Object val) {
        map.put(JobXMLUtil.asAttributeName(key), val);
    }

    public static String asAttributeName(String key) {
        return ATTR_PREFIX + key;
    }

    public static void makeAttribute(Map map, String key) {
        Object remove;
        if (null != map && null != (remove = map.remove(key))) {
            map.put(JobXMLUtil.asAttributeName(key), remove);
        }
    }

    public static Map toAttrMap(String key, Object val) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (null != key) {
            map.put(JobXMLUtil.asAttributeName(key), val);
        }
        return map;
    }

    public static String pluralize(String key) {
        if (key.endsWith(PLURAL_SUFFIX)) {
            return key;
        }
        if (key.endsWith(PLURAL_REPL)) {
            String k = key.substring(0, key.length() - PLURAL_REPL.length());
            return k + PLURAL_SUFFIX;
        }
        return key + PLURAL_SUFFIX;
    }

    public static Map makePlural(Map map, String key) {
        map.put(JobXMLUtil.pluralize(key), map.remove(key));
        return map;
    }

    public static String asCDATAName(String key) {
        return key + CDATA_SUFFIX;
    }

    public static String asDataValueKey(String key) {
        return key + DATAVALUE_SUFFIX;
    }
}

