/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.IExecutionProviders;
import com.dtolabs.rundeck.core.common.IExecutionServices;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;

public class BaseFrameworkExecutionProviders
implements IExecutionProviders {
    private IExecutionServices executionServices;

    public static BaseFrameworkExecutionProviders create(IExecutionServices executionServices) {
        BaseFrameworkExecutionProviders baseFrameworkExecutionProviders = new BaseFrameworkExecutionProviders();
        baseFrameworkExecutionProviders.setExecutionServices(executionServices);
        return baseFrameworkExecutionProviders;
    }

    @Override
    public StepExecutor getStepExecutorForItem(StepExecutionItem item, String project) throws ExecutionServiceException {
        return this.executionServices.getStepExecutionService().getExecutorForItem(item);
    }

    @Override
    public FileCopier getFileCopierForNodeAndProject(INodeEntry node, ExecutionContext context) throws ExecutionServiceException {
        return (FileCopier)this.executionServices.getFileCopierService().getProviderForNodeAndProject(node, context);
    }

    @Override
    public NodeExecutor getNodeExecutorForNodeAndProject(INodeEntry node, ExecutionContext context) throws ExecutionServiceException {
        return (NodeExecutor)this.executionServices.getNodeExecutorService().getProviderForNodeAndProject(node, context);
    }

    @Override
    public NodeStepExecutor getNodeStepExecutorForItem(NodeStepExecutionItem item, String project) throws ExecutionServiceException {
        return this.executionServices.getNodeStepExecutorService().getExecutorForExecutionItem(item);
    }

    @Override
    public NodeDispatcher getNodeDispatcherForContext(ExecutionContext context) throws ExecutionServiceException {
        return this.executionServices.getNodeDispatcherService().getNodeDispatcher(context);
    }

    public IExecutionServices getExecutionServices() {
        return this.executionServices;
    }

    public void setExecutionServices(IExecutionServices executionServices) {
        this.executionServices = executionServices;
    }
}

