/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.component;

public interface ContextComponent<T> {
    public String getName();

    public Class<T> getType();

    public T getObject();

    default public boolean isUseOnce() {
        return false;
    }

    public static <T> ContextComponent<T> with(String name, T o, Class<T> type) {
        return ContextComponent.with(name, o, type, false);
    }

    public static <T> ContextComponent<T> with(final String name, final T o, final Class<T> type, final boolean useOnce) {
        return new ContextComponent<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public T getObject() {
                return o;
            }

            @Override
            public boolean isUseOnce() {
                return useOnce;
            }
        };
    }

    public static boolean equalsTo(ContextComponent acomp, ContextComponent bcomp) {
        return bcomp.getName().equals(acomp.getName()) && bcomp.getType().equals(acomp.getType());
    }
}

