/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.AdditiveListNodeSet;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceErrors;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryResourceModelSource
implements ResourceModelSource,
ResourceModelSourceErrors,
Configurable {
    static final Logger logger = LoggerFactory.getLogger((String)DirectoryResourceModelSource.class.getName());
    private final Framework framework;
    private Configuration configuration;
    private final Map<File, ResourceModelSource> sourceCache = Collections.synchronizedMap(new HashMap());
    public static final Description DESCRIPTION = DescriptionBuilder.builder().name("directory").title("Directory").description("Scans a directory and loads all resource document files").property(PropertyBuilder.builder().string("directory").title("Directory Path").description("Directory path to scan").required(true).build()).metadata("glyphicon", "folder-open").build();
    private List<String> sourceErrors;

    public DirectoryResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    @Override
    public void configure(Properties configuration) throws ConfigurationException {
        Configuration configuration1 = Configuration.fromProperties(configuration);
        this.configure(configuration1);
    }

    void configure(Configuration config) throws ConfigurationException {
        this.configuration = config;
        this.configuration.validate();
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        this.loadFileSources(this.configuration.directory, this.configuration.project);
        return this.loadNodeSets();
    }

    @Override
    public List<String> getModelSourceErrors() {
        return this.sourceErrors != null ? Collections.unmodifiableList(this.sourceErrors) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INodeSet loadNodeSets() throws ResourceModelSourceException {
        Map<File, ResourceModelSource> map = this.sourceCache;
        synchronized (map) {
            ArrayList<String> errs = new ArrayList<String>();
            AdditiveListNodeSet listNodeSet = new AdditiveListNodeSet();
            for (File file : this.sortFiles(this.sourceCache.keySet())) {
                String msg;
                try {
                    listNodeSet.addNodeSet(this.sourceCache.get(file).getNodes());
                }
                catch (ResourceModelSourceException t) {
                    msg = "Error loading file: " + file + ": " + t.getLocalizedMessage();
                    errs.add(msg);
                    logger.warn(msg);
                    logger.debug(msg, (Throwable)t);
                }
                catch (Throwable t) {
                    msg = "Error loading file: " + file + ": " + t.getClass().getName() + ": " + t.getLocalizedMessage();
                    errs.add(msg);
                    logger.warn(msg);
                    logger.debug(msg, t);
                }
            }
            this.sourceErrors = errs;
            return listNodeSet;
        }
    }

    private File[] sortFiles(Collection<File> files) {
        File[] arr = files.toArray(new File[files.size()]);
        Arrays.sort(arr, new Comparator<File>(){

            @Override
            public int compare(File file, File file1) {
                return file.getName().compareTo(file1.getName());
            }
        });
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileSources(File directory, String project) {
        HashSet<String> exts;
        File[] files;
        if (!directory.isDirectory()) {
            logger.warn("Not a directory: " + directory);
        }
        if (null != (files = directory.listFiles(new FilenameFilter(exts = new HashSet<String>(this.framework.getResourceFormatParserService().listSupportedFileExtensions())){
            final /* synthetic */ Set val$exts;
            {
                this.val$exts = set;
            }

            @Override
            public boolean accept(File file, String s) {
                return this.val$exts.contains(ResourceFormatParserService.getFileExtension(s));
            }
        }))) {
            Arrays.sort(files, null);
            Map<File, ResourceModelSource> map = this.sourceCache;
            synchronized (map) {
                HashSet<File> trackedFiles = new HashSet<File>(this.sourceCache.keySet());
                for (File file : files) {
                    trackedFiles.remove(file);
                    if (this.sourceCache.containsKey(file)) continue;
                    logger.debug("Adding new resources file to cache: " + file.getAbsolutePath());
                    try {
                        ResourceModelSource source = this.createFileSource(project, file);
                        this.sourceCache.put(file, source);
                    }
                    catch (ExecutionServiceException e) {
                        e.printStackTrace();
                        logger.debug("Failed adding file " + file.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
                    }
                }
                for (File oldFile : trackedFiles) {
                    logger.debug("Removing from cache: " + oldFile.getAbsolutePath());
                    this.sourceCache.remove(oldFile);
                }
            }
        }
    }

    private ResourceModelSource createFileSource(String project, File file) throws ExecutionServiceException {
        Properties properties1 = FileResourceModelSource.Configuration.build().project(project).file(file).generateFileAutomatically(false).includeServerNode(false).getProperties();
        return this.framework.getResourceModelSourceService().getSourceForConfiguration("file", properties1);
    }

    public String toString() {
        return "DirectoryResourceModelSource{directory=" + this.configuration.directory + '}';
    }

    public static class Configuration {
        public static final String DIRECTORY = "directory";
        public static final String PROJECT = "project";
        String project;
        File directory;

        public Configuration(Properties config) {
            this.configure(config);
        }

        public static Configuration fromProperties(Properties props) {
            return new Configuration(props);
        }

        public void configure(Properties props) {
            if (props.containsKey(PROJECT)) {
                this.project = props.getProperty(PROJECT);
            }
            if (props.containsKey(DIRECTORY)) {
                this.directory = new File(props.getProperty(DIRECTORY));
            }
        }

        public void validate() throws ConfigurationException {
            if (null == this.project) {
                throw new ConfigurationException("project is required");
            }
            if (null == this.directory) {
                throw new ConfigurationException("directory is required");
            }
            if (this.directory.isFile()) {
                throw new ConfigurationException("path specified is not a directory: " + this.directory);
            }
        }
    }
}

