/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class MapData {
    public static boolean metaBooleanProp(Map<String, Object> data, String property, boolean defaultValue) {
        return MapData.metaPathBoolean(data, property, defaultValue);
    }

    private static boolean asBoolean(Object o) {
        if (o == Boolean.TRUE) {
            return true;
        }
        return "true".equals(o);
    }

    private static Optional<Object> metaPath(Map<String, Object> data, String path) {
        String[] parts = path.split("\\.", 2);
        if (parts.length <= 0) {
            return Optional.empty();
        }
        Object object = data.get(parts[0]);
        if (parts.length > 1) {
            if (object instanceof Map) {
                Map meta2 = (Map)object;
                return MapData.metaPath(meta2, parts[1]);
            }
            return Optional.empty();
        }
        return Optional.ofNullable(object);
    }

    public static boolean metaPathBoolean(Map<String, Object> data, String path, boolean defaultValue) {
        return MapData.metaPathValue(data, path, defaultValue, MapData::asBoolean);
    }

    public static String metaPathString(Map<String, Object> data, String path, String defaultValue) {
        return MapData.metaPathValue(data, path, defaultValue, MapData::asString);
    }

    public static <T> T metaPathValue(Map<String, Object> data, String path, T defaultValue, Function<Object, T> toValue) {
        Optional<Object> o = MapData.metaPath(data, path);
        return o.map(toValue).orElse(defaultValue);
    }

    public static String metaStringProp(Map<String, Object> data, String property) {
        return MapData.metaStringProp(data, property, null);
    }

    public static String metaStringProp(Map<String, Object> data, String property, String defaultValue) {
        return MapData.metaPathString(data, property, defaultValue);
    }

    private static String asString(Object obj) {
        return obj instanceof String ? (String)obj : null;
    }

    public static Integer asInt(Object obj) {
        try {
            return obj != null ? (obj instanceof Integer ? (Integer)obj : (obj instanceof String ? Integer.valueOf(Integer.parseInt((String)obj)) : null)) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long asLong(Object obj) {
        try {
            return obj != null ? (obj instanceof Long ? (Long)obj : (obj instanceof String ? Long.valueOf(Long.parseLong((String)obj)) : null)) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Map<String, String> toStringStringMap(Map input) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : input.keySet()) {
            map.put(o.toString(), input.get(o) != null ? input.get(o).toString() : "");
        }
        return map;
    }
}

