/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.acl;

import java.io.IOException;
import java.io.InputStream;
import org.rundeck.app.acl.ACLFileManager;
import org.rundeck.app.acl.ACLFileManagerListener;
import org.rundeck.app.acl.DelegateACLFileManager;
import org.rundeck.app.acl.Listeners;
import org.rundeck.app.acl.ListenersManager;

public class ListenableACLFileManager
extends DelegateACLFileManager {
    private final Listeners listeners = new ListenersManager();

    public ListenableACLFileManager(ACLFileManager delegate) {
        super(delegate);
    }

    @Override
    public void addListener(ACLFileManagerListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(ACLFileManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public long storePolicyFile(String fileName, InputStream input) throws IOException {
        long val = super.storePolicyFile(fileName, input);
        this.notifyUpdated(fileName);
        return val;
    }

    @Override
    public boolean deletePolicyFile(String fileName) throws IOException {
        boolean val = super.deletePolicyFile(fileName);
        if (val) {
            this.notifyDeleted(fileName);
        }
        return val;
    }

    @Override
    public long storePolicyFileContents(String fileName, String fileText) throws IOException {
        long val = super.storePolicyFileContents(fileName, fileText);
        this.notifyUpdated(fileName);
        return val;
    }

    protected void notifyDeleted(String fileName) {
        this.listeners.notifyDeleted(fileName);
    }

    protected void notifyUpdated(String fileName) {
        this.listeners.notifyUpdated(fileName);
    }
}

