/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common.impl;

import com.dtolabs.rundeck.core.common.FileUpdater;
import com.dtolabs.rundeck.core.common.FileUpdaterException;
import com.dtolabs.rundeck.core.common.URLFileUpdaterFactory;
import com.dtolabs.rundeck.core.http.ApacheHttpClient;
import com.dtolabs.rundeck.core.http.HttpClient;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.apache.http.HttpResponse;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFileUpdater
implements FileUpdater {
    static final Logger logger = LoggerFactory.getLogger((String)URLFileUpdater.class.getName());
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String E_TAG = "ETag";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final int DEFAULT_TIMEOUT = 60;
    public static final Factory FACTORY = new Factory();
    URL url;
    File cacheMetadata;
    File cachedContent;
    private String reasonCode;
    private int resultCode = 0;
    private String acceptHeader;
    private String contentType;
    private boolean useCaching;
    private int timeout;
    private String username;
    private String password;

    public URLFileUpdater(URL url, String acceptHeader, int timeout, File cacheMetadataFile, File cachedContent, boolean useCaching, String username, String password) {
        this.url = url;
        this.cacheMetadata = cacheMetadataFile;
        this.acceptHeader = acceptHeader;
        this.cachedContent = cachedContent;
        this.timeout = timeout >= 0 ? timeout : 60;
        this.useCaching = useCaching;
        this.username = username;
        this.password = password;
    }

    public static URLFileUpdaterFactory factory() {
        return FACTORY;
    }

    @Override
    public void updateFile(File destinationFile) throws FileUpdaterException {
        if ("http".equalsIgnoreCase(this.url.getProtocol()) || "https".equalsIgnoreCase(this.url.getProtocol())) {
            this.updateHTTPUrl(destinationFile);
        } else if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            this.updateFileUrl(destinationFile);
        } else {
            throw new FileUpdaterException("Unsupported protocol: " + this.url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileUrl(File destinationFile) throws FileUpdaterException {
        try {
            File srfile = new File(new URI(this.url.toExternalForm()));
            try (FileInputStream in = new FileInputStream(srfile);
                 FileOutputStream out = new FileOutputStream(destinationFile);){
                Streams.copyStream(in, out);
            }
        }
        catch (URISyntaxException e) {
            throw new FileUpdaterException("Invalid URI: " + this.url);
        }
        catch (FileNotFoundException e) {
            throw new FileUpdaterException(e);
        }
        catch (IOException e) {
            throw new FileUpdaterException(e);
        }
    }

    private void updateHTTPUrl(File destinationFile) throws FileUpdaterException {
        Properties cacheProperties;
        ApacheHttpClient httpClient = new ApacheHttpClient();
        if (this.useCaching) {
            cacheProperties = this.loadCacheData(this.cacheMetadata);
            this.contentTypeFromCache(cacheProperties);
        } else {
            cacheProperties = null;
        }
        String cleanUrl = this.url.toExternalForm().replaceAll("^(https?://)([^:@/]+):[^@/]*@", "$1$2:****@");
        String urlToUse = this.url.toExternalForm();
        try {
            urlToUse = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), this.url.getFile()).toExternalForm();
            httpClient.setUri(this.url.toURI());
            if (null != this.url.getUserInfo()) {
                UsernamePasswordCredentials cred = new UsernamePasswordCredentials(this.url.getUserInfo());
                httpClient.setBasicAuthCredentials(cred.getUserName(), cred.getPassword());
            } else if (null != this.username && null != this.password) {
                httpClient.setBasicAuthCredentials(this.username, this.password);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new FileUpdaterException("Failed to configure base URL for authentication: " + e.getMessage(), e);
        }
        httpClient.setTimeout(this.timeout * 1000);
        httpClient.setFollowRedirects(true);
        httpClient.setMethod(HttpClient.Method.GET);
        httpClient.addHeader("Accept", Optional.ofNullable(this.acceptHeader).orElse("*/*"));
        if (this.useCaching) {
            this.applyCacheHeaders(cacheProperties, httpClient);
        }
        logger.debug("Making remote request: " + cleanUrl);
        try {
            httpClient.execute(rsp -> {
                this.resultCode = rsp.getStatusLine().getStatusCode();
                this.reasonCode = rsp.getStatusLine().getReasonPhrase();
                if (this.useCaching && 304 == this.resultCode) {
                    logger.debug("Content NOT MODIFIED: file up to date");
                } else if (200 == this.resultCode) {
                    this.determineContentType((HttpResponse)rsp);
                    try (FileOutputStream output = new FileOutputStream(destinationFile);){
                        Streams.copyStream(rsp.getEntity().getContent(), output);
                    }
                    if (destinationFile.length() < 1L && !destinationFile.delete()) {
                        logger.warn("Failed to remove empty file: " + destinationFile.getAbsolutePath());
                    }
                    if (this.useCaching) {
                        this.cacheResponseInfo((HttpResponse)rsp, this.cacheMetadata);
                    }
                } else {
                    throw new FileUpdaterException("Unable to retrieve content: result code: " + this.resultCode + " " + this.reasonCode);
                }
            });
        }
        catch (Exception e) {
            throw new FileUpdaterException(e);
        }
    }

    private void applyCacheHeaders(Properties cacheProperties, HttpClient<HttpResponse> client) {
        if (this.isCachedContentPresent() && null != this.contentType) {
            if (cacheProperties.containsKey(E_TAG)) {
                client.addHeader(IF_NONE_MATCH, cacheProperties.getProperty(E_TAG));
            }
            if (cacheProperties.containsKey(LAST_MODIFIED)) {
                client.addHeader(IF_MODIFIED_SINCE, cacheProperties.getProperty(LAST_MODIFIED));
            }
        }
    }

    private boolean isCachedContentPresent() {
        return this.cachedContent.isFile() && this.cachedContent.length() > 0L;
    }

    private void contentTypeFromCache(Properties cacheProperties) {
        if (cacheProperties.containsKey(CONTENT_TYPE)) {
            this.contentType = cacheProperties.getProperty(CONTENT_TYPE);
            this.cleanContentType();
        }
    }

    private void determineContentType(HttpResponse response) {
        if (null != response.getEntity().getContentType().getValue()) {
            this.contentType = response.getEntity().getContentType().getValue();
            this.cleanContentType();
        }
    }

    private void cleanContentType() {
        if (null != this.contentType && this.contentType.indexOf(";") > 0) {
            this.contentType = this.contentType.substring(0, this.contentType.indexOf(";")).trim();
        }
    }

    private Properties loadCacheData(File cacheFile) {
        Properties cacheProperties = new Properties();
        if (cacheFile.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(cacheFile);){
                cacheProperties.load(fileInputStream);
            }
            catch (IOException e) {
                logger.debug("failed to load cache data from file: " + cacheFile);
            }
        }
        return cacheProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResponseInfo(HttpResponse httpResponse, File cacheFile) {
        Properties newprops = new Properties();
        if (null != httpResponse.getFirstHeader(LAST_MODIFIED)) {
            newprops.setProperty(LAST_MODIFIED, httpResponse.getFirstHeader(LAST_MODIFIED).getValue());
        }
        if (null != httpResponse.getFirstHeader(E_TAG)) {
            newprops.setProperty(E_TAG, httpResponse.getFirstHeader(E_TAG).getValue());
        }
        if (null != httpResponse.getFirstHeader(CONTENT_TYPE)) {
            newprops.setProperty(CONTENT_TYPE, httpResponse.getFirstHeader(CONTENT_TYPE).getValue());
        }
        if (newprops.size() > 0) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(cacheFile);){
                newprops.store(fileOutputStream, "URLFileUpdater cache data for URL: " + this.url);
            }
            catch (IOException e) {
                logger.debug("Failed to write cache header info to file: " + cacheFile + ", " + e.getMessage(), (Throwable)e);
            }
        } else if (cacheFile.exists() && !cacheFile.delete()) {
            logger.warn("Unable to delete cachefile: " + cacheFile.getAbsolutePath());
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public static class Factory
    implements URLFileUpdaterFactory {
        @Override
        public FileUpdater fileUpdaterFromURL(URL url, String username, String password) {
            return new URLFileUpdater(url, null, -1, null, null, false, username, password);
        }
    }
}

