/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.SequentialStrategyProfile;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategyProfile;
import com.dtolabs.rundeck.core.execution.workflow.engine.OperationCompleted;
import com.dtolabs.rundeck.core.execution.workflow.engine.StepCallable;
import com.dtolabs.rundeck.core.execution.workflow.engine.StepOperation;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.rules.Condition;
import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.Rule;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateLogger;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.States;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemBuilder;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventListener;
import com.dtolabs.rundeck.core.rules.Workflows;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWorkflowExecutor
extends BaseWorkflowExecutor {
    static final Logger logger = LoggerFactory.getLogger(EngineWorkflowExecutor.class);
    public static final String STEP_FLOW_CONTROL_KEY = "step.#.flowcontrol";
    public static final String STEP_ANY_FLOW_CONTROL_HALT_KEY = "step.any.flowcontrol.halt";
    public static final String STEP_FLOW_CONTROL_STATUS_KEY = "step.#.flowstatus";
    public static final String WORKFLOW_STATE_KEY = "workflow.state";
    public static final String WORKFLOW_KEEPGOING_KEY = "workflow.keepgoing";
    public static final String WORKFLOW_STATE_STARTED = "started";
    public static final String STEP_BEFORE_KEY = "before.step.#";
    public static final String STEP_AFTER_KEY = "after.step.#";
    public static final String STEP_STATE_KEY = "step.#.state";
    public static final String STEP_ANY_STATE_SKIPPED_KEY = "step.any.state.skipped";
    public static final String STEP_ANY_STATE_SUCCESS_KEY = "step.any.state.success";
    public static final String STEP_ANY_STATE_FAILED_KEY = "step.any.state.failed";
    public static final String STEP_COMPLETED_KEY = "step.#.completed";
    public static final String VALUE_TRUE = Boolean.TRUE.toString();
    private static final Rule FLOW_CONTROL_HALT_END_WORKFLOW = Rules.conditionsRule(Rules.equalsCondition("step.any.flowcontrol.halt", VALUE_TRUE), Workflows.getWorkflowEndState());
    public static final String VALUE_FALSE = Boolean.FALSE.toString();
    private static final Rule STEP_FAILURE_KEEPGOING_FALSE_END_WORKFLOW = Rules.conditionsRule(Rules.conditionSet(Rules.equalsCondition("step.any.state.failed", VALUE_TRUE), Rules.equalsCondition("workflow.keepgoing", VALUE_FALSE)), Workflows.getWorkflowEndState());
    private static final Set<Rule> INITIAL_RULES = Collections.unmodifiableSet(new HashSet<Rule>(Arrays.asList(FLOW_CONTROL_HALT_END_WORKFLOW, STEP_FAILURE_KEEPGOING_FALSE_END_WORKFLOW)));
    public static final String STEP_STATE_RESULT_SUCCESS = "success";
    public static final String STEP_STATE_RESULT_FAILURE = "failure";
    public static final String STEP_STATE_RESULT_SKIPPED = "skipped";
    public static final String STEP_CONTROL_KEY = "step.#.start";
    public static final String STEP_CONTROL_SKIP_KEY = "step.#.skip";
    public static final String STEP_CONTROL_START = "start";
    public static final String STEP_DATA_RESULT_KEY_PREFIX = "step.#.result.";
    private Supplier<WorkflowSystemBuilder> workflowSystemBuilderSupplier;

    public EngineWorkflowExecutor(IFramework framework) {
        super(framework);
        this.setWorkflowSystemBuilderSupplier(Workflows::builder);
    }

    public static String stepKey(String key, Object stepNum) {
        return key.replace("#", stepNum.toString());
    }

    public static void updateStateWithStepResultData(MutableStateObj state, Object identity, Map<String, Object> failureData) {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        if (null != failureData) {
            for (String s : failureData.keySet()) {
                stringStringHashMap.put(EngineWorkflowExecutor.stepKey(STEP_DATA_RESULT_KEY_PREFIX + s, identity), failureData.get(s).toString());
            }
        }
        if (stringStringHashMap.size() > 0) {
            state.updateState(stringStringHashMap);
        }
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        Augmentor component = executionContext.useSingleComponentOfType(Augmentor.class).orElseGet(DefaultAugmentor::new);
        MutableStateObj mutable = component.getInitialState(item, executionContext);
        WFSharedContext sharedContext = component.getSharedContext(executionContext);
        String workflowId = mutable.getState().get("workflow.id");
        ExecutionListener executionListener = executionContext.getExecutionListener();
        LogOut logDebug = EngineWorkflowExecutor.createDebugLog(workflowId, executionListener);
        LogOut logWarn = EngineWorkflowExecutor.createWarnLog(workflowId, executionListener);
        LogOut logErr = EngineWorkflowExecutor.createErrLog(workflowId, executionListener);
        logDebug.log("Start EngineWorkflowExecutor");
        StateLogger state = new StateLogger(mutable, logDebug::log);
        IWorkflow workflow = item.getWorkflow();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        ArrayList<StepExecutionResult> stepResults = new ArrayList<StepExecutionResult>();
        WorkflowStatusResult workflowResult = null;
        NodesetEmptyException exception = null;
        try {
            WorkflowStrategy strategyForWorkflow = EngineWorkflowExecutor.setupWorkflowStrategy(executionContext, item, workflow, this.getFramework());
            NodesSelector nodeSelector = executionContext.getNodeSelector();
            this.validateNodeSet(executionContext, nodeSelector);
            RuleEngine ruleEngine = EngineWorkflowExecutor.setupRulesEngine(executionContext, workflow, strategyForWorkflow);
            WorkflowStrategyProfile profile = strategyForWorkflow.getProfile();
            if (profile == null) {
                profile = new SequentialStrategyProfile();
            }
            WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
            Set<StepOperation> operations = EngineWorkflowExecutor.buildOperations(this, executionContext, item, workflow, wlistener, ruleEngine, state, profile, logDebug);
            logDebug.log("Create rule engine with rules: " + ruleEngine);
            logDebug.log("Create workflow engine with state: " + state);
            ArrayList<WorkflowSystemEventListener> list = new ArrayList<WorkflowSystemEventListener>();
            list.add(event -> logDebug.log(String.format("%s: %s", new Object[]{event.getEventType(), event.getMessage()})));
            executionContext.useAllComponentsOfType(WorkflowSystemEventListener.class, list::add);
            WorkflowSystem<Map<String, String>> workflowEngine = EngineWorkflowExecutor.buildWorkflowSystem(state, ruleEngine, strategyForWorkflow.getThreadCount(), this.getWorkflowSystemBuilderSupplier(), list);
            WorkflowSystem.SharedData<WFSharedContext, Map> dataContextSharedData = WorkflowSystem.SharedData.with(sharedContext::merge, () -> sharedContext, () -> DataContextUtils.flattenDataContext(sharedContext.getData(ContextView.global())));
            Set operationResults = workflowEngine.processOperations(operations, dataContextSharedData);
            String statusString = null;
            ControlBehavior controlBehavior = null;
            boolean workflowSuccess = !workflowEngine.isInterrupted();
            for (WorkflowSystem.OperationResult operationResult : operationResults) {
                OperationCompleted completed = (OperationCompleted)operationResult.getSuccess();
                StepOperation operation = operationResult.getOperation();
                Throwable failure = operationResult.getFailure();
                if (completed != null) {
                    BaseWorkflowExecutor.StepResultCapture result = completed.getStepResultCapture();
                    if (!result.getStepResult().isSuccess()) {
                        stepFailures.put(completed.getStepNum(), result.getStepResult());
                        workflowSuccess = false;
                    }
                    stepResults.add(result.getStepResult());
                    if (result.getControlBehavior() == null || result.getControlBehavior() == ControlBehavior.Continue) continue;
                    controlBehavior = result.getControlBehavior();
                    statusString = result.getStatusString();
                    continue;
                }
                workflowSuccess = false;
                EngineWorkflowExecutor.addUnknownStepFailure(executionContext, stepFailures, operation, failure, logDebug, logErr);
            }
            EngineWorkflowExecutor.logSkippedOperations(executionContext, operations, logWarn);
            workflowResult = EngineWorkflowExecutor.workflowResult(workflowSuccess, statusString, null != controlBehavior ? controlBehavior : ControlBehavior.Continue, sharedContext);
        }
        catch (ExecutionServiceException e) {
            logErr.log("Exception: " + e.getClass() + ": " + e.getMessage());
            return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(stepResults, new HashMap<String, Collection<StepExecutionResult>>(), stepFailures, e, WorkflowResultFailed, sharedContext);
        }
        catch (NodesetEmptyException e) {
            Boolean successOnEmptyNodeFilter = Boolean.valueOf(executionContext.getDataContext().get("job").get("successOnEmptyNodeFilter"));
            if (!successOnEmptyNodeFilter.booleanValue()) {
                exception = e;
                e.printStackTrace();
                executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
                workflowResult = WorkflowResultFailed;
            }
            logDebug.log("No matched nodes");
            workflowResult = EngineWorkflowExecutor.workflowResult(true, null, ControlBehavior.Continue, sharedContext);
        }
        NodesetEmptyException fexception = exception;
        Map<String, Collection<StepExecutionResult>> nodeFailures = this.convertFailures(stepFailures);
        return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(stepResults, nodeFailures, stepFailures, fexception, workflowResult, sharedContext);
    }

    private static LogOut createDebugLog(String workflowId, ExecutionListener executionListener) {
        return message -> {
            String logMessage = String.format("[wf:%s] %s", workflowId, message);
            logger.debug(logMessage);
            executionListener.log(4, logMessage);
        };
    }

    private static LogOut createWarnLog(String workflowId, ExecutionListener executionListener) {
        return message -> {
            String logMessage = String.format("[wf:%s] %s", workflowId, message);
            logger.warn(logMessage);
            executionListener.log(1, logMessage);
        };
    }

    private static LogOut createErrLog(String workflowId, ExecutionListener executionListener) {
        return message -> {
            String logMessage = String.format("[wf:%s] %s", workflowId, message);
            logger.error(logMessage);
            executionListener.log(0, logMessage);
        };
    }

    private static WorkflowSystem<Map<String, String>> buildWorkflowSystem(MutableStateObj state, RuleEngine ruleEngine, int wfThreadcount, Supplier<WorkflowSystemBuilder> workflowSystemBuilder, List<WorkflowSystemEventListener> workflowSystemEventListeners) {
        return workflowSystemBuilder.get().ruleEngine(ruleEngine).executor(() -> wfThreadcount > 0 ? Executors.newFixedThreadPool(wfThreadcount) : Executors.newCachedThreadPool()).state(state).listeners(workflowSystemEventListeners).build();
    }

    private static void addUnknownStepFailure(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> stepFailures, StepOperation operation, Throwable failure, LogOut logDebug, LogOut logErr) {
        StepFailureReason reason = StepFailureReason.Unknown;
        String message = String.format("Exception while executing step [%d]: \t[%s]", operation.getStepNum(), failure.toString());
        if (failure instanceof CancellationException || failure instanceof InterruptedException) {
            reason = StepFailureReason.Interrupted;
            message = String.format("Cancellation while running step [%d]", operation.getStepNum());
        } else {
            logDebug.log(message + ": " + Throwables.getStackTraceAsString((Throwable)failure));
        }
        logErr.log(message);
        stepFailures.put(operation.getStepNum(), StepExecutionResultImpl.wrapStepException(failure instanceof StepException ? (StepException)failure : new StepException(message, failure, reason)));
    }

    private static void logSkippedOperations(StepExecutionContext executionContext, Set<StepOperation> operations, LogOut logOut) {
        operations.stream().filter(op -> !op.isDidRun()).forEach(op -> logOut.log(String.format("Step [%d] did not run. start conditions: %s, skip conditions: %s", op.getStepNum(), op.getStartTriggerConditions(), op.getSkipTriggerConditions())));
    }

    private static RuleEngine setupRulesEngine(StepExecutionContext executionContext, IWorkflow workflow, WorkflowStrategy strategyForWorkflow) {
        RuleEngine ruleEngine = Rules.createEngine(INITIAL_RULES);
        strategyForWorkflow.setup(ruleEngine, executionContext, workflow);
        return ruleEngine;
    }

    public static WorkflowStrategy setupWorkflowStrategy(StepExecutionContext executionContext, WorkflowExecutionItem item, IWorkflow workflow, IFramework framework) throws ExecutionServiceException {
        Object o1;
        Object o;
        Map<String, Object> pluginConfig = new HashMap<String, Object>();
        Map<String, Object> pluginConfig1 = workflow.getPluginConfig();
        if (pluginConfig1 != null && (o = pluginConfig1.get("WorkflowStrategy")) instanceof Map && (o1 = ((Map)o).get(workflow.getStrategy())) instanceof Map) {
            pluginConfig = (Map)o1;
        }
        WorkflowStrategy strategyForWorkflow = framework.getWorkflowStrategyService().getStrategyForWorkflow(item, pluginConfig, executionContext.getFrameworkProject());
        return strategyForWorkflow;
    }

    private static Set<StepOperation> buildOperations(EngineWorkflowExecutor engineWorkflowExecutor, StepExecutionContext executionContext, WorkflowExecutionItem item, IWorkflow workflow, WorkflowExecutionListener wlistener, RuleEngine ruleEngine, MutableStateObj state, WorkflowStrategyProfile profile, LogOut log) {
        HashSet<StepOperation> operations = new HashSet<StepOperation>();
        List<StepExecutionItem> commands = workflow.getCommands();
        for (int i = 0; i < commands.size(); ++i) {
            int stepNum = executionContext.getStepNumber() + i;
            StepExecutionItem cmd = workflow.getCommands().get(i);
            state.updateState(profile.getInitialStateForStep(stepNum, item, i == 0));
            Set<Condition> stepStartTriggerConditions = profile.getStartConditionsForStep(item, stepNum, i == 0);
            log.log(String.format("start conditions for step [%d]: %s", stepNum, stepStartTriggerConditions));
            StateObj stepRunTriggerState = EngineWorkflowExecutor.createTriggerControlStateForStep(stepNum);
            ruleEngine.addRule(Rules.conditionsRule(stepStartTriggerConditions, stepRunTriggerState));
            Set<Condition> stepSkipTriggerConditions = profile.getSkipConditionsForStep(item, stepNum, i == 0);
            StateObj stepSkipTriggerState = null;
            if (null != stepSkipTriggerConditions && !stepSkipTriggerConditions.isEmpty()) {
                stepSkipTriggerState = EngineWorkflowExecutor.createSkipTriggerStateForStep(stepNum);
                ruleEngine.addRule(Rules.conditionsRule(Condition.and(Condition.and(stepStartTriggerConditions), Condition.and(stepSkipTriggerConditions)), stepSkipTriggerState));
                log.log(String.format("skip conditions for step [%d]: %s", stepNum, stepSkipTriggerConditions));
            }
            operations.add(new StepOperation(stepNum, cmd.getLabel(), new StepCallable(engineWorkflowExecutor, executionContext, workflow.isKeepgoing(), wlistener, stepNum, cmd), stepRunTriggerState, stepSkipTriggerState, stepStartTriggerConditions, stepSkipTriggerConditions));
        }
        return operations;
    }

    private static StateObj createTriggerControlStateForStep(int stepNum) {
        return States.state(EngineWorkflowExecutor.stepKey(STEP_CONTROL_KEY, stepNum), VALUE_TRUE);
    }

    private static StateObj createSkipTriggerStateForStep(int stepNum) {
        return States.state(EngineWorkflowExecutor.stepKey(STEP_CONTROL_SKIP_KEY, stepNum), VALUE_TRUE);
    }

    public Supplier<WorkflowSystemBuilder> getWorkflowSystemBuilderSupplier() {
        return this.workflowSystemBuilderSupplier;
    }

    public void setWorkflowSystemBuilderSupplier(Supplier<WorkflowSystemBuilder> workflowSystemBuilderSupplier) {
        this.workflowSystemBuilderSupplier = workflowSystemBuilderSupplier;
    }

    public static class DefaultAugmentor
    implements Augmentor {
        @Override
        public MutableStateObj getInitialState(WorkflowExecutionItem item, StepExecutionContext executionContext) {
            MutableStateObj mutable = States.mutable(DataContextUtils.flattenDataContext(executionContext.getDataContext()));
            mutable.updateState(Workflows.getNewWorkflowState());
            mutable.updateState(EngineWorkflowExecutor.WORKFLOW_KEEPGOING_KEY, Boolean.toString(item.getWorkflow().isKeepgoing()));
            return mutable;
        }

        @Override
        public WFSharedContext getSharedContext(StepExecutionContext executionContext) {
            return WFSharedContext.withBase(executionContext.getSharedDataContext());
        }
    }

    public static interface Augmentor {
        public MutableStateObj getInitialState(WorkflowExecutionItem var1, StepExecutionContext var2);

        public WFSharedContext getSharedContext(StepExecutionContext var1);
    }

    private static interface LogOut {
        public void log(String var1);
    }

    public static abstract class BaseProfile
    implements WorkflowStrategyProfile {
        @Override
        public StateObj getInitialStateForStep(int stepNum, WorkflowExecutionItem item, boolean isFirstStep) {
            MutableStateObj state = States.mutable(EngineWorkflowExecutor.stepKey(EngineWorkflowExecutor.STEP_BEFORE_KEY, stepNum), VALUE_TRUE);
            state.updateState(EngineWorkflowExecutor.stepKey(EngineWorkflowExecutor.STEP_AFTER_KEY, stepNum), VALUE_FALSE);
            return state;
        }

        @Override
        public Set<Condition> getSkipConditionsForStep(WorkflowExecutionItem item, int stepNum, boolean isFirstStep) {
            return Collections.singleton(Rules.equalsCondition(EngineWorkflowExecutor.stepKey(EngineWorkflowExecutor.STEP_COMPLETED_KEY, stepNum), VALUE_TRUE));
        }
    }
}

