/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.spi;

import org.rundeck.app.spi.AppService;

public interface Services {
    public boolean hasService(Class<? extends AppService> var1);

    default public <T extends AppService> T getService(Class<T> type) {
        throw new IllegalStateException("Required service " + type.getName() + " was not available");
    }

    default public Services combine(Services other) {
        return Services.combine(this, other);
    }

    public static Services combine(final Services a, final Services b) {
        return new Services(){

            @Override
            public boolean hasService(Class<? extends AppService> type) {
                return a.hasService(type) || b.hasService(type);
            }

            @Override
            public <T extends AppService> T getService(Class<T> type) {
                if (a.hasService(type)) {
                    return a.getService(type);
                }
                return b.getService(type);
            }
        };
    }
}

