/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeDesc;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodeBaseImpl;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeEntryImpl
extends NodeBaseImpl
implements INodeEntry,
INodeDesc {
    protected static final String USER_AT_HOSTNAME_REGEX = "([^@])+@([^@:])+";
    protected static final String PORT_REGEX = "([^:]+):([0-9]+)";
    public static final String OS_NAME = "osName";
    public static final String OS_FAMILY = "osFamily";
    public static final String OS_VERSION = "osVersion";
    public static final String HOSTNAME = "hostname";
    public static final String OS_ARCH = "osArch";
    public static final String USERNAME = "username";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "nodename";
    public static final String TAGS = "tags";
    static final String[] PROPERTY_ATTRIBUTE_NAMES = new String[]{"osName", "osFamily", "osVersion", "hostname", "osArch", "username", "description", "nodename", "tags"};
    private Set tags = new HashSet();
    private Map<String, String> attributes = new HashMap<String, String>();
    private String project;

    public NodeEntryImpl() {
    }

    public NodeEntryImpl(String nodename) {
        this();
        this.setNodename(nodename);
    }

    public NodeEntryImpl(String hostname, String nodename) {
        this(nodename);
        this.setHostname(hostname);
    }

    public static INodeEntry create(String hostname, String nodename) {
        return new NodeEntryImpl(hostname, nodename);
    }

    @Override
    public void setNodename(String nodename) {
        super.setNodename(nodename);
        this.setAttribute(NAME, nodename);
    }

    @Override
    public String getNodename() {
        return this.getAttribute(NAME);
    }

    @Override
    public Set getTags() {
        return this.tags;
    }

    public void setTags(Set tags) {
        this.tags = tags;
        Object[] objects = tags.toArray();
        Arrays.sort(objects);
        this.setAttribute(TAGS, StringArrayUtil.asString(objects, ", "));
    }

    @Override
    public String getOsName() {
        return this.getAttribute(OS_NAME);
    }

    public void setOsName(String osName) {
        this.setAttribute(OS_NAME, osName);
    }

    @Override
    public String getOsFamily() {
        return this.getAttribute(OS_FAMILY);
    }

    public void setOsFamily(String osFamily) {
        this.setAttribute(OS_FAMILY, osFamily);
    }

    @Override
    public String getOsVersion() {
        return this.getAttribute(OS_VERSION);
    }

    public void setOsVersion(String osVersion) {
        this.setAttribute(OS_VERSION, osVersion);
    }

    @Override
    public String getHostname() {
        return this.getAttribute(HOSTNAME);
    }

    public void setHostname(String hostname) {
        this.setAttribute(HOSTNAME, hostname);
    }

    @Override
    public String getOsArch() {
        return this.getAttribute(OS_ARCH);
    }

    public void setOsArch(String osArch) {
        this.setAttribute(OS_ARCH, osArch);
    }

    @Override
    public String getUsername() {
        return this.getAttribute(USERNAME);
    }

    public void setUsername(String username) {
        this.setAttribute(USERNAME, username);
    }

    @Override
    public boolean equals(INodeDesc node) {
        return this.getNodename().equals(node.getNodename());
    }

    public String toString() {
        return "NodeEntryImpl{tags=" + this.tags + ", attributes=" + this.attributes + ", project='" + this.project + '\'' + '}';
    }

    public static boolean containsUserName(String host) {
        if (null == host) {
            return false;
        }
        return host.matches(USER_AT_HOSTNAME_REGEX);
    }

    @Override
    public boolean containsUserName() {
        return NodeEntryImpl.containsUserName(this.getHostname());
    }

    public static String extractUserName(String hostname) {
        if (NodeEntryImpl.containsUserName(hostname)) {
            return hostname.substring(0, hostname.indexOf("@"));
        }
        return null;
    }

    @Override
    public String extractUserName() {
        String username = this.getUsername();
        if (null != username && !"".equals(username)) {
            return username;
        }
        return NodeEntryImpl.extractUserName(this.getHostname());
    }

    public static String extractHostname(String host) {
        String extracted = host;
        if (NodeEntryImpl.containsUserName(host)) {
            extracted = host.substring(host.indexOf("@") + 1, host.length());
        }
        if (NodeEntryImpl.containsPort(extracted)) {
            extracted = host.substring(0, host.indexOf(":"));
        }
        return extracted;
    }

    @Override
    public String extractHostname() {
        return NodeEntryImpl.extractHostname(this.getHostname());
    }

    @Override
    public String extractPort() {
        return NodeEntryImpl.extractPort(this.getHostname());
    }

    public static String extractPort(String host) {
        if (NodeEntryImpl.containsPort(host)) {
            return host.substring(host.indexOf(":") + 1, host.length());
        }
        return null;
    }

    @Override
    public boolean containsPort() {
        return NodeEntryImpl.containsPort(this.getHostname());
    }

    public static boolean containsPort(String host) {
        if (null == host) {
            return false;
        }
        return host.matches(PORT_REGEX);
    }

    public void setFrameworkProject(String project) {
        this.project = project;
    }

    @Override
    public String getFrameworkProject() {
        return this.project;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setDescription(String description) {
        this.setAttribute(DESCRIPTION, description);
    }

    @Override
    public String getDescription() {
        return this.getAttribute(DESCRIPTION);
    }

    public Map<String, String> getExtendedAttributes() {
        return NodeEntryImpl.nodeExtendedAttributes(this);
    }

    public static Map<String, String> nodeExtendedAttributes(INodeEntry node) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (null != node.getAttributes()) {
            attrs.putAll(node.getAttributes());
        }
        for (String attr : PROPERTY_ATTRIBUTE_NAMES) {
            attrs.remove(attr);
        }
        return attrs;
    }

    public static Map<String, Map<String, List<String>>> nodeNamespacedAttributes(INodeEntry node) {
        Map<String, String> attrs = NodeEntryImpl.nodeExtendedAttributes(node);
        HashMap<String, Map<String, List<String>>> nsAttrs = new HashMap<String, Map<String, List<String>>>();
        for (String s : attrs.keySet()) {
            String[] parts = null;
            String ns = "";
            String key = null;
            if (s.contains(":")) {
                parts = s.split(":", 2);
            }
            if (null != parts && parts.length > 1) {
                ns = NodeEntryImpl.notBlank(parts[0], "");
                key = parts[1];
            } else {
                ns = "";
                key = s;
            }
            if (null == nsAttrs.get(ns)) {
                nsAttrs.put(ns, new HashMap());
            }
            ((Map)nsAttrs.get(ns)).put(key, Arrays.asList(s, attrs.get(s)));
        }
        return nsAttrs;
    }

    private static String notBlank(String part, String defaultValue) {
        return null != part && !"".equals(part.trim()) ? part : defaultValue;
    }

    public String getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public String setAttribute(String name, String value) {
        if (null != value) {
            return this.getAttributes().put(name, value);
        }
        this.getAttributes().remove(name);
        return value;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

