/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class PropertiesCache {
    private HashMap<File, Long> mtimes = new HashMap();
    private HashMap<File, Properties> props = new HashMap();

    public synchronized boolean needsReload(File file) throws IOException {
        Long aLong;
        long lastMod = file.lastModified();
        if (!file.exists()) {
            this.mtimes.remove(file);
        }
        return null == (aLong = this.mtimes.get(file)) || lastMod > aLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getProperties(File file) throws IOException {
        if (this.needsReload(file)) {
            Properties fileprops = new Properties();
            FileInputStream is = new FileInputStream(file);
            try {
                fileprops.load(is);
            }
            finally {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            this.mtimes.put(file, file.lastModified());
            this.props.put(file, fileprops);
            return fileprops;
        }
        return this.props.get(file);
    }

    public synchronized void touch(File file) {
        this.mtimes.remove(file);
        this.props.remove(file);
    }
}

