/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils.cache;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class FileCache<T extends Cacheable> {
    private HashMap<File, T> cache = new HashMap();
    private HashMap<File, Long> expiry = new HashMap();
    private final Expiration<T> expiration;

    public FileCache() {
        this(new LastModifiedExpiration());
    }

    public FileCache(Expiration<T> expiration) {
        this.expiration = expiration;
    }

    public synchronized void remove(File file) {
        Cacheable t = (Cacheable)this.cache.get(file);
        this.expiry.remove(file);
        this.cache.remove(file);
        if (null != t && t instanceof Expireable) {
            Expireable exp = (Expireable)t;
            exp.expire();
        }
    }

    public Set<File> cachedFiles() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    public static String memoFile(File file) {
        return file.getName() + ":" + file.lastModified() + ":" + file.length();
    }

    public static MemoFile memoize(File file) {
        return new MemoFileImpl(file, FileCache.memoFile(file));
    }

    public synchronized T get(File file, ItemCreator<T> creator) {
        Cacheable entry;
        if (!file.exists()) {
            this.remove(file);
            return null;
        }
        long lastmod = file.lastModified();
        Long cachetime = this.expiry.get(file);
        Cacheable orig = (Cacheable)this.cache.get(file);
        if (null == cachetime || this.expiration.isExpired(file, cachetime, orig)) {
            entry = (Cacheable)creator.createCacheItemForFile(file);
            if (null == entry) {
                this.remove(file);
                return null;
            }
            if (null != orig && !entry.equals(orig)) {
                this.remove(file);
                this.cache.put(file, entry);
            } else if (null == orig) {
                this.cache.put(file, entry);
            }
            this.expiry.put(file, lastmod);
        } else {
            entry = (Cacheable)this.cache.get(file);
        }
        return (T)entry;
    }

    public static interface Expireable
    extends Cacheable {
        public void expire();
    }

    public static interface Cacheable {
    }

    public static class LastModifiedExpiration<T>
    implements Expiration<T> {
        @Override
        public boolean isExpired(File file, Long cacheTime, T item) {
            return file.lastModified() > cacheTime;
        }
    }

    public static interface Expiration<T> {
        public boolean isExpired(File var1, Long var2, T var3);
    }

    public static interface ItemCreator<T> {
        public T createCacheItemForFile(File var1);
    }

    public static class MemoFileImpl
    implements MemoFile {
        private File file;
        private String memo;

        public MemoFileImpl(File file, String memo) {
            this.file = file;
            this.memo = memo;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        @Override
        public String getMemo() {
            return this.memo;
        }

        public void setMemo(String memo) {
            this.memo = memo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemoFileImpl memoFile = (MemoFileImpl)o;
            if (!this.file.equals(memoFile.file)) {
                return false;
            }
            return this.memo.equals(memoFile.memo);
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = 31 * result + this.memo.hashCode();
            return result;
        }
    }

    public static interface MemoFile {
        public File getFile();

        public String getMemo();
    }
}

