/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.acl;

import com.dtolabs.rundeck.core.authorization.providers.BaseValidator;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageManager;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.rundeck.app.acl.ACLFileManager;
import org.rundeck.app.acl.AclPolicyFile;
import org.rundeck.storage.api.Resource;

public class ACLStorageFileManager
implements ACLFileManager {
    private final String prefix;
    private final StorageManager storage;
    private final BaseValidator validator;
    private final String pattern = ".*\\.aclpolicy";

    @Override
    public List<String> listStoredPolicyFiles() {
        return this.storage.listDirPaths(this.prefix, ".*\\.aclpolicy").stream().map(it -> it.substring(this.prefix.length())).collect(Collectors.toList());
    }

    @Override
    public boolean existsPolicyFile(String file) {
        return this.storage.existsFileResource(this.prefix + file);
    }

    @Override
    public String getPolicyFileContents(String fileName) throws IOException {
        AclPolicyFile aclPolicy = this.getAclPolicy(fileName);
        if (aclPolicy == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streams.copyStream(aclPolicy.getInputStream(), baos);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    public long loadPolicyFileContents(String fileName, OutputStream outputStream) throws IOException {
        if (!this.existsPolicyFile(fileName)) {
            return -1L;
        }
        return this.storage.loadFileResource(this.prefix + fileName, outputStream);
    }

    @Override
    public AclPolicyFile getAclPolicy(String fileName) {
        if (!this.existsPolicyFile(fileName)) {
            return null;
        }
        Resource<ResourceMeta> resource = this.storage.getFileResource(this.prefix + fileName);
        if (resource == null) {
            return null;
        }
        ResourceMeta file = (ResourceMeta)resource.getContents();
        return new AclPolicyImpl(() -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }, file.getModificationTime(), file.getCreationTime(), fileName);
    }

    @Override
    public long storePolicyFileContents(String fileName, String fileText) {
        byte[] bytes = fileText.getBytes(StandardCharsets.UTF_8);
        Resource<ResourceMeta> result = this.storage.writeFileResource(this.prefix + fileName, new ByteArrayInputStream(bytes), new HashMap<String, String>());
        return bytes.length;
    }

    @Override
    public long storePolicyFile(String fileName, InputStream input) {
        Resource<ResourceMeta> result = this.storage.writeFileResource(this.prefix + fileName, input, new HashMap<String, String>());
        return ((ResourceMeta)result.getContents()).getContentLength();
    }

    @Override
    public boolean deletePolicyFile(String fileName) {
        return this.storage.deleteFileResource(this.prefix + fileName);
    }

    public static ACLStorageFileManagerBuilder builder() {
        return new ACLStorageFileManagerBuilder();
    }

    public ACLStorageFileManager(String prefix, StorageManager storage, BaseValidator validator) {
        this.prefix = prefix;
        this.storage = storage;
        this.validator = validator;
    }

    @Override
    public BaseValidator getValidator() {
        return this.validator;
    }

    public static class ACLStorageFileManagerBuilder {
        private String prefix;
        private StorageManager storage;
        private BaseValidator validator;

        ACLStorageFileManagerBuilder() {
        }

        public ACLStorageFileManagerBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ACLStorageFileManagerBuilder storage(StorageManager storage) {
            this.storage = storage;
            return this;
        }

        public ACLStorageFileManagerBuilder validator(BaseValidator validator) {
            this.validator = validator;
            return this;
        }

        public ACLStorageFileManager build() {
            return new ACLStorageFileManager(this.prefix, this.storage, this.validator);
        }

        public String toString() {
            return "ACLStorageFileManager.ACLStorageFileManagerBuilder(prefix=" + this.prefix + ", storage=" + this.storage + ", validator=" + this.validator + ")";
        }
    }

    static class AclPolicyImpl
    implements AclPolicyFile {
        private final Supplier<InputStream> inputStream;
        private final Date modified;
        private final Date created;
        private final String name;

        @Override
        public InputStream getInputStream() {
            return this.inputStream.get();
        }

        public AclPolicyImpl(Supplier<InputStream> inputStream, Date modified, Date created, String name) {
            this.inputStream = inputStream;
            this.modified = modified;
            this.created = created;
            this.name = name;
        }

        @Override
        public Date getModified() {
            return this.modified;
        }

        @Override
        public Date getCreated() {
            return this.created;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

