/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node.impl;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdater;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdaterBuilder;
import com.dtolabs.rundeck.core.data.BaseDataContext;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.DefaultScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptURLCommandExecutionItem;
import com.dtolabs.rundeck.core.utils.Converter;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptURLNodeStepExecutor
implements NodeStepExecutor {
    public static final Logger logger = LoggerFactory.getLogger((String)ScriptURLNodeStepExecutor.class.getName());
    public static final String SERVICE_IMPLEMENTATION_NAME = "script-url";
    private static final int DEFAULT_TIMEOUT = 30;
    private static final boolean USE_CACHE = true;
    public static final String UTF_8 = "UTF-8";
    private File cacheDir;
    private Framework framework;
    private ScriptFileNodeStepUtils scriptUtils = new DefaultScriptFileNodeStepUtils();
    public static final Converter<String, String> urlPathEncoder = s -> {
        try {
            return URLEncoder.encode(s, UTF_8).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    };
    public static final Converter<String, String> urlQueryEncoder = s -> {
        try {
            return URLEncoder.encode(s, UTF_8).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    };

    public ScriptURLNodeStepExecutor(Framework framework) {
        this.framework = framework;
        this.cacheDir = new File(Constants.getBaseVar(framework.getBaseDir().getAbsolutePath()) + "/cache/ScriptURLNodeStepExecutor");
    }

    private static String hashURL(String url) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(url.getBytes(Charset.forName(UTF_8)));
            return new String(Hex.encodeHex((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return Integer.toString(url.hashCode());
        }
    }

    public ScriptFileNodeStepUtils getScriptUtils() {
        return this.scriptUtils;
    }

    public void setScriptUtils(ScriptFileNodeStepUtils scriptUtils) {
        this.scriptUtils = scriptUtils;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        ScriptURLCommandExecutionItem script = (ScriptURLCommandExecutionItem)((Object)item);
        File destinationTempFile = this.downloadURLToTempFile(context, node, script);
        boolean expandTokens = true;
        if (context.getFramework().hasProperty("execution.script.tokenexpansion.enabled")) {
            expandTokens = "true".equals(context.getFramework().getProperty("execution.script.tokenexpansion.enabled"));
        }
        if (expandTokens) {
            expandTokens = script.isExpandTokenInScriptFile();
        }
        return this.scriptUtils.executeScriptFile(context, node, null, destinationTempFile.getAbsolutePath(), null, script.getFileExtension(), script.getArgs(), script.getScriptInterpreter(), script.getInterpreterArgsQuoted(), this.framework.getExecutionService(), expandTokens);
    }

    private File downloadURLToTempFile(StepExecutionContext context, INodeEntry node, ScriptURLCommandExecutionItem script) throws NodeStepException {
        URL url;
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new RuntimeException("Unable to create cachedir: " + this.cacheDir.getAbsolutePath());
        }
        WFSharedContext sharedContext = new WFSharedContext(context.getSharedDataContext());
        sharedContext.merge(ContextView.global(), context.getDataContextObject());
        sharedContext.merge(ContextView.node(node.getNodename()), new BaseDataContext("node", DataContextUtils.nodeData(node)));
        String finalUrl = ScriptURLNodeStepExecutor.expandUrlString(script.getURLString(), sharedContext, node.getNodename());
        try {
            url = new URL(finalUrl);
        }
        catch (MalformedURLException e) {
            throw new NodeStepException((Throwable)e, (FailureReason)StepFailureReason.ConfigurationFailure, node.getNodename());
        }
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().log(4, "Requesting URL: " + url.toExternalForm());
        }
        String cleanUrl = url.toExternalForm().replaceAll("^(https?://)([^:@/]+):[^@/]*@", "$1$2:****@");
        String tempFileName = ScriptURLNodeStepExecutor.hashURL(url.toExternalForm()) + ".temp";
        File destinationTempFile = new File(this.cacheDir, tempFileName);
        File destinationCacheData = new File(this.cacheDir, tempFileName + ".cache.properties");
        URLFileUpdaterBuilder urlFileUpdaterBuilder = new URLFileUpdaterBuilder().setUrl(url).setAcceptHeader("*/*").setTimeout(30);
        urlFileUpdaterBuilder.setCacheMetadataFile(destinationCacheData).setCachedContent(destinationTempFile).setUseCaching(true);
        URLFileUpdater updater = urlFileUpdaterBuilder.createURLFileUpdater();
        try {
            UpdateUtils.update(updater, destinationTempFile);
            logger.debug("Updated nodes resources file: " + destinationTempFile);
        }
        catch (UpdateUtils.UpdateException e) {
            if (!destinationTempFile.isFile() || destinationTempFile.length() < 1L) {
                throw new NodeStepException("Error requesting URL Script: " + cleanUrl + ": " + e.getMessage(), (Throwable)e, (FailureReason)Reason.URLDownloadFailure, node.getNodename());
            }
            logger.error("Error requesting URL script: " + cleanUrl + ": " + e.getMessage(), (Throwable)e);
        }
        return destinationTempFile;
    }

    public static String expandUrlString(String urlString, MultiDataContext<ContextView, DataContext> dataContext, String nodename) {
        int qindex = urlString.indexOf(63);
        StringBuilder builder = new StringBuilder();
        builder.append(SharedDataContextUtils.replaceDataReferences(qindex > 0 ? urlString.substring(0, qindex) : urlString, dataContext, ContextView.node(nodename), ContextView::nodeStep, DataContextUtils.replaceMissingOptionsWithBlank, true, false));
        if (qindex > 0) {
            builder.append("?");
            if (qindex < urlString.length() - 1) {
                builder.append(SharedDataContextUtils.replaceDataReferences(urlString.substring(qindex + 1), dataContext, ContextView.node(nodename), ContextView::nodeStep, urlQueryEncoder, true, false));
            }
        }
        return builder.toString();
    }

    static enum Reason implements FailureReason
    {
        URLDownloadFailure;

    }
}

