/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PluginValidation {
    private State state;
    private final List<String> messages;

    PluginValidation(State state, List<String> messages) {
        this.state = state;
        this.messages = messages;
    }

    public static PluginValidationBuilder builder() {
        return new PluginValidationBuilder();
    }

    public String toString() {
        return "PluginValidation(state=" + (Object)((Object)this.getState()) + ", messages=" + this.getMessages() + ")";
    }

    public State getState() {
        return this.state;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginValidation)) {
            return false;
        }
        PluginValidation other = (PluginValidation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        List<String> this$messages = this.getMessages();
        List<String> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginValidation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        List<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public static class PluginValidationBuilder {
        private State state;
        private ArrayList<String> messages;

        PluginValidationBuilder() {
        }

        public PluginValidationBuilder state(State state) {
            this.state = state;
            return this;
        }

        public PluginValidationBuilder message(String message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public PluginValidationBuilder messages(Collection<? extends String> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public PluginValidationBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public PluginValidation build() {
            List<String> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<String>(this.messages));
                }
            }
            return new PluginValidation(this.state, messages);
        }

        public String toString() {
            return "PluginValidation.PluginValidationBuilder(state=" + (Object)((Object)this.state) + ", messages=" + this.messages + ")";
        }
    }

    public static enum State {
        VALID(true),
        INCOMPATIBLE(false),
        INVALID(false);

        private boolean valid;

        private State(boolean validity) {
            this.valid = validity;
        }

        State or(State other) {
            return this.ordinal() > other.ordinal() ? this : other;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

