/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format.json;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Plugin(name="resourcejson", service="ResourceFormatGenerator")
public class ResourceJsonFormatGenerator
implements ResourceFormatGenerator,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "resourcejson";
    private final ObjectMapper test = new ObjectMapper();
    public static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("json")));
    public static final List<String> MIME_TYPES = Collections.unmodifiableList(Arrays.asList("application/json", "text/json"));
    private static final Description DESCRIPTION = DescriptionBuilder.builder().name("resourcejson").title("Resource JSON").description("The Rundeck Resource JSON format 1.0 (bundled)").build();

    @Override
    public Description getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Set<String> getFileExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public void generateDocument(INodeSet nodeset, OutputStream stream) throws ResourceFormatGeneratorException {
        try {
            this.test.writeValue(stream, this.convertNodes(nodeset));
        }
        catch (IOException e) {
            throw new ResourceFormatGeneratorException(e);
        }
    }

    private Object convertNodes(INodeSet nodeset) {
        HashMap stringMapHashMap = new HashMap();
        for (INodeEntry node : nodeset) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(node.getAttributes());
            stringMapHashMap.put(node.getNodename(), map);
        }
        return stringMapHashMap;
    }
}

