/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.tasks.net;

import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.dtolabs.rundeck.core.utils.SSHAgentProcess;
import com.dtolabs.rundeck.plugins.PluginLogger;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHUserInfo;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.TeeOutputStream;

public class ExtSSHExec
extends SSHBase
implements SSHTaskBuilder.SSHExecInterface {
    private static final int BUFFER_SIZE = 8192;
    private static final int RETRY_INTERVAL = 500;
    private String command = null;
    private long maxwait = 0L;
    private long connectTimeout = 0L;
    private long commandTimeout = 0L;
    private Thread thread = null;
    private String outputProperty = null;
    private File outputFile = null;
    private String inputProperty = null;
    private File inputFile = null;
    private boolean append = false;
    private InputStream inputStream = null;
    private OutputStream secondaryStream = null;
    private DisconnectHolder disconnectHolder = null;
    private PluginLogger logger;
    private Resource commandResource = null;
    private List<Environment.Variable> envVars = null;
    private Boolean enableSSHAgent = false;
    private Integer ttlSSHAgent = 0;
    private SSHAgentProcess sshAgentProcess = null;
    private String bindAddress;
    public static final String COMMAND_TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";
    public static final String CON_TIMEOUT_MESSAGE = "Connection timeout.";
    private boolean allocatePty = false;
    private boolean passEnvVar = false;
    private int exitStatus = -1;
    private String knownHosts;
    private InputStream sshKeyData;
    private Map<String, String> sshConfig;
    private int antLogLevel = 2;

    @Override
    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandResource(String f) {
        this.commandResource = new FileResource(new File(f));
    }

    @Override
    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    @Override
    public long getTimeout() {
        return this.maxwait;
    }

    @Override
    public void setConnectTimeout(long sshTimeout) {
        this.connectTimeout = sshTimeout;
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setCommandTimeout(long sshTimeout) {
        this.commandTimeout = sshTimeout;
    }

    @Override
    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setInput(File input) {
        this.inputFile = input;
    }

    public void setInputProperty(String inputProperty) {
        this.inputProperty = inputProperty;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void setOutputproperty(String property) {
        this.outputProperty = property;
    }

    public void setAllocatePty(boolean b) {
        this.allocatePty = b;
    }

    public void passEnvVar(boolean b) {
        this.passEnvVar = b;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public void addEnv(Environment.Variable env) {
        if (null == this.envVars) {
            this.envVars = new ArrayList<Environment.Variable>();
        }
        this.envVars.add(env);
    }

    public DisconnectHolder getDisconnectHolder() {
        return this.disconnectHolder;
    }

    public void setDisconnectHolder(DisconnectHolder disconnectHolder) {
        this.disconnectHolder = disconnectHolder;
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public void setPluginLogger(PluginLogger logger) {
        this.logger = logger;
    }

    public int getAntLogLevel() {
        return this.antLogLevel;
    }

    public void setAntLogLevel(int antLogLevel) {
        this.antLogLevel = antLogLevel;
    }

    @Override
    public Map<String, String> getSshConfig() {
        return this.sshConfig;
    }

    @Override
    public InputStream getSshKeyData() {
        return this.sshKeyData;
    }

    @Override
    public SSHAgentProcess getSSHAgentProcess() {
        return this.sshAgentProcess;
    }

    @Override
    public void setSSHAgentProcess(SSHAgentProcess sshAgentProcess) {
        this.sshAgentProcess = sshAgentProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.getHost() == null) {
            throw new BuildException("Host is required.");
        }
        if (this.getUserInfo().getName() == null) {
            throw new BuildException("Username is required.");
        }
        if (this.getUserInfo().getKeyfile() == null && this.getUserInfo().getPassword() == null && this.getSshKeyData() == null) {
            throw new BuildException("Password or Keyfile is required.");
        }
        if (this.command == null && this.commandResource == null) {
            throw new BuildException("Command or commandResource is required.");
        }
        if (this.inputFile != null && this.inputProperty != null) {
            throw new BuildException("You can't specify both inputFile and inputProperty.");
        }
        if (this.inputFile != null && !this.inputFile.exists()) {
            throw new BuildException("The input file " + this.inputFile.getAbsolutePath() + " does not exist.");
        }
        Session session = null;
        StringBuffer output = new StringBuffer();
        try {
            session = this.openSession();
            if (null != this.getDisconnectHolder()) {
                final Session sub = session;
                this.getDisconnectHolder().setDisconnectable(new Disconnectable(){

                    @Override
                    public void disconnect() {
                        sub.disconnect();
                    }
                });
            }
            if (this.command != null) {
                this.executeCommand(session, this.command, output);
            } else {
                try {
                    String cmd;
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.commandResource.getInputStream()));
                    while ((cmd = br.readLine()) != null) {
                        this.executeCommand(session, cmd, output);
                        output.append("\n");
                    }
                    FileUtils.close((Reader)br);
                }
                catch (IOException e) {
                    if (this.getFailonerror()) {
                        throw new BuildException((Throwable)e);
                    }
                    this.log("Caught exception: " + e.getMessage(), 0);
                }
            }
        }
        catch (JSchException e) {
            if (this.getFailonerror()) {
                throw new BuildException((Throwable)e);
            }
            this.log("Caught exception: " + e.getMessage(), 0);
        }
        finally {
            try {
                if (null != this.sshAgentProcess) {
                    this.sshAgentProcess.stopAgent();
                }
            }
            catch (IOException e) {
                this.log("Caught exception: " + e.getMessage(), 0);
            }
            if (this.outputProperty != null) {
                this.getProject().setNewProperty(this.outputProperty, output.toString());
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Session session, String cmd, StringBuffer sb) throws BuildException {
        String inputData;
        ByteArrayOutputStream out = null != this.outputFile || null != this.outputProperty ? new ByteArrayOutputStream() : null;
        OutputStream teeout = null != this.getSecondaryStream() && null != out ? new TeeOutputStream((OutputStream)out, this.getSecondaryStream()) : (null != this.getSecondaryStream() ? this.getSecondaryStream() : (null != out ? out : null));
        Object tee = null != teeout ? new TeeOutputStream(teeout, (OutputStream)new KeepAliveOutputStream((OutputStream)System.out)) : new KeepAliveOutputStream((OutputStream)System.out);
        InputStream istream = null;
        if (this.inputFile != null) {
            try {
                istream = new FileInputStream(this.inputFile);
            }
            catch (IOException e) {
                this.log("Failed to read " + this.inputFile + " because of: " + e.getMessage(), 1);
            }
        }
        if (this.inputProperty != null && (inputData = this.getProject().getProperty(this.inputProperty)) != null) {
            istream = new ByteArrayInputStream(inputData.getBytes());
        }
        if (this.getInputStream() != null) {
            istream = this.getInputStream();
        }
        long sshConTimeout = this.connectTimeout > 0L ? this.connectTimeout : this.maxwait;
        try {
            session.setTimeout((int)sshConTimeout);
            final ChannelExec channel = (ChannelExec)session.openChannel("exec");
            if (null != this.sshAgentProcess) {
                channel.setAgentForwarding(true);
            }
            channel.setCommand(cmd);
            channel.setOutputStream((OutputStream)tee);
            channel.setExtOutputStream((OutputStream)new KeepAliveOutputStream((OutputStream)System.err), true);
            if (istream != null) {
                channel.setInputStream(istream);
            }
            channel.setPty(this.allocatePty);
            if (null != this.envVars && this.envVars.size() > 0 && this.passEnvVar) {
                for (Environment.Variable env : this.envVars) {
                    channel.setEnv(env.getKey(), env.getValue());
                }
            }
            int jschConTimeout = sshConTimeout > 0L ? (int)sshConTimeout : 604800000;
            channel.connect(jschConTimeout);
            this.thread = new Thread(){

                @Override
                public void run() {
                    while (!channel.isClosed()) {
                        if (ExtSSHExec.this.thread == null) {
                            return;
                        }
                        try {
                            2.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            this.thread.start();
            this.thread.join(this.commandTimeout);
            if (this.thread.isAlive()) {
                this.thread = null;
                if (this.getFailonerror()) {
                    throw new BuildException(COMMAND_TIMEOUT_MESSAGE);
                }
                this.log(COMMAND_TIMEOUT_MESSAGE, 0);
            } else {
                if (this.outputFile != null && null != out) {
                    this.writeToFile(out.toString(), this.append, this.outputFile);
                }
                this.exitStatus = channel.getExitStatus();
                int ec = channel.getExitStatus();
                if (ec != 0) {
                    String msg = "Remote command failed with exit status " + ec;
                    if (this.getFailonerror()) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (JSchException e) {
            if (e.getMessage().contains("session is down")) {
                if (this.getFailonerror()) {
                    throw new BuildException(CON_TIMEOUT_MESSAGE, (Throwable)e);
                }
                this.log(CON_TIMEOUT_MESSAGE, 0);
            } else {
                if (this.getFailonerror()) {
                    throw new BuildException((Throwable)e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
        catch (Exception e) {
            if (this.getFailonerror()) {
                throw new BuildException((Throwable)e);
            }
            this.log("Caught exception: " + e.getMessage(), 0);
        }
        finally {
            if (null != out) {
                sb.append(out.toString());
            }
            FileUtils.close((InputStream)istream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String from, boolean append, File to) throws IOException {
        try (OutputStreamWriter out = null;){
            int bytesRead;
            out = new FileWriter(to.getAbsolutePath(), append);
            StringReader in = new StringReader(from);
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
    }

    @Override
    public void setSshKeyData(InputStream sshKeyData) {
        this.sshKeyData = sshKeyData;
    }

    @Override
    public void setKnownhosts(String knownHosts) {
        this.knownHosts = knownHosts;
        super.setKnownhosts(knownHosts);
    }

    @Override
    public void setSshConfig(Map<String, String> config) {
        this.sshConfig = config;
    }

    protected Session openSession() throws JSchException {
        return SSHTaskBuilder.openSession(this);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getSecondaryStream() {
        return this.secondaryStream;
    }

    public void setSecondaryStream(OutputStream secondaryStream) {
        this.secondaryStream = secondaryStream;
    }

    @Override
    public String getKeyfile() {
        return this.getUserInfo().getKeyfile();
    }

    @Override
    public String getKnownhosts() {
        return this.knownHosts;
    }

    @Override
    public SSHUserInfo getUserInfo() {
        return super.getUserInfo();
    }

    @Override
    public void setEnableSSHAgent(Boolean enableSSHAgent) {
        this.enableSSHAgent = enableSSHAgent;
    }

    @Override
    public Boolean getEnableSSHAgent() {
        return this.enableSSHAgent;
    }

    @Override
    public void setTtlSSHAgent(Integer ttlSSHAgent) {
        this.ttlSSHAgent = ttlSSHAgent;
    }

    @Override
    public Integer getTtlSSHAgent() {
        return this.ttlSSHAgent;
    }

    @Override
    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    public static interface DisconnectHolder {
        public void setDisconnectable(Disconnectable var1);
    }

    public static interface Disconnectable {
        public void disconnect();
    }
}

