/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.Project;

public class PropertyUtil {
    public static Properties expand(Map properties) {
        Properties expandedProperties = new Properties();
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = (String)entry.getKey();
            String keyValue = (String)entry.getValue();
            String expandedKeyValue = PropertyUtil.expand(keyValue, properties);
            expandedProperties.setProperty(key, expandedKeyValue);
        }
        return expandedProperties;
    }

    public static String expand(String keyString, Properties properties) {
        return PropertyUtil.expand(keyString, (Map)properties);
    }

    public static String expand(String keyString, Map properties) {
        String expandedLine = PropertyUtil.lineExpand(keyString, properties);
        if (PropertyUtil.resolvesToLiteral(expandedLine) || expandedLine.equals(keyString)) {
            return expandedLine;
        }
        return PropertyUtil.expand(expandedLine, properties);
    }

    public static String expand(String keyString, Project project) {
        return PropertyUtil.expand(keyString, project.getProperties());
    }

    private static String lineExpand(String keyString, Map properties) {
        if (PropertyUtil.resolvesToLiteral(keyString)) {
            return keyString;
        }
        StringTokenizer keyStringTokenizer = new StringTokenizer(keyString, "${}", true);
        StringBuilder output = new StringBuilder();
        State state = State.NoToken;
        String propName = null;
        StringBuilder tokenbuff = new StringBuilder();
        while (keyStringTokenizer.hasMoreTokens()) {
            String nextToken = keyStringTokenizer.nextToken();
            tokenbuff.append(nextToken);
            State newState = state.newStateForToken(nextToken);
            if (newState == State.PropertyName) {
                propName = nextToken;
            } else if (newState == State.Final) {
                String expVal = (String)properties.get(propName);
                if (expVal != null) {
                    tokenbuff = new StringBuilder(expVal);
                }
                propName = null;
                newState = State.NoToken;
            }
            if (newState == State.NoToken) {
                output.append((CharSequence)tokenbuff);
                tokenbuff = new StringBuilder();
            }
            state = newState;
        }
        output.append((CharSequence)tokenbuff);
        return output.toString();
    }

    private static boolean resolvesToLiteral(String keyString) {
        return !keyString.contains("${");
    }

    public static class PropertyUtilException
    extends RuntimeException {
        public PropertyUtilException(String msg) {
            super(msg);
        }
    }

    private static enum State {
        NoToken(null),
        Dollar(NoToken),
        DollarLeftbracket(Dollar),
        PropertyName(DollarLeftbracket),
        Final(PropertyName);

        final State allowed;

        private State(State allowed) {
            this.allowed = allowed;
        }

        State newStateForToken(String token) {
            if ("$".equals(token)) {
                return this.transitionTo(Dollar);
            }
            if ("{".equals(token)) {
                return this.transitionTo(DollarLeftbracket);
            }
            if ("}".equals(token)) {
                return this.transitionTo(Final);
            }
            return this.transitionTo(PropertyName);
        }

        boolean allowedFrom(State previous) {
            return null == this.allowed || this.allowed == previous;
        }

        State transitionTo(State next) {
            if (next.allowedFrom(this)) {
                return next;
            }
            return NoToken;
        }
    }
}

