/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.LogBuffer;
import com.dtolabs.rundeck.core.utils.LogBufferManager;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Function;

public class ThreadBoundLogOutputStream<D, T extends LogBuffer<D>>
extends OutputStream {
    private Consumer<D> logger;
    private ThreadLocal<Holder<T>> buffer = new ThreadLocal();
    private InheritableThreadLocal<LogBufferManager<D, T>> manager = new InheritableThreadLocal();
    private InheritableThreadLocal<Charset> charset = new InheritableThreadLocal();
    private Function<Charset, LogBufferManager<D, T>> factory;

    public ThreadBoundLogOutputStream(Consumer<D> logger, Charset charset, Function<Charset, LogBufferManager<D, T>> factory) {
        this.logger = logger;
        this.charset.set(charset);
        this.factory = factory;
    }

    public Charset setCharset(Charset charset) {
        Charset prev = (Charset)this.charset.get();
        this.charset.set(charset);
        return prev;
    }

    public LogBufferManager<D, T> installManager() {
        LogBufferManager<D, T> manager = this.factory.apply((Charset)this.charset.get());
        this.manager.set(manager);
        return manager;
    }

    private LogBufferManager<D, T> getOrCreateManager() {
        if (null == this.manager.get()) {
            this.installManager();
        }
        return (LogBufferManager)this.manager.get();
    }

    @Override
    public void write(int b) {
        Holder<T> log = this.getOrReset();
        if (b == 10) {
            this.flushEventBuffer();
        } else if (b == 13) {
            log.setCrchar(true);
        } else {
            if (log.isCrchar()) {
                this.flushEventBuffer();
                this.resetEventBuffer();
            }
            log.getBuffer().write((byte)b);
        }
    }

    private Holder<T> getOrReset() {
        if (this.buffer.get() == null || this.buffer.get().getBuffer().isEmpty()) {
            this.resetEventBuffer();
        }
        return this.buffer.get();
    }

    private void resetEventBuffer() {
        if (this.buffer.get() == null) {
            this.buffer.set(new Holder<T>(this.getOrCreateManager().create((Charset)this.charset.get())));
        } else {
            this.buffer.get().reset();
        }
    }

    private void flushEventBuffer() {
        Holder<T> holder = this.buffer.get();
        this.logger.accept(holder.getBuffer().get());
        holder.clear();
    }

    public void flushBuffers() {
        this.getOrCreateManager().flush(this.logger);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.flushBuffers();
        super.close();
    }

    private static class Holder<X extends LogBuffer> {
        final X buffer;
        boolean crchar;

        public void clear() {
            this.crchar = false;
            this.buffer.clear();
        }

        public void reset() {
            this.crchar = false;
            this.buffer.reset();
        }

        public X getBuffer() {
            return this.buffer;
        }

        public boolean isCrchar() {
            return this.crchar;
        }

        public void setCrchar(boolean crchar) {
            this.crchar = crchar;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Holder)) {
                return false;
            }
            Holder other = (Holder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCrchar() != other.isCrchar()) {
                return false;
            }
            X this$buffer = this.getBuffer();
            X other$buffer = other.getBuffer();
            return !(this$buffer == null ? other$buffer != null : !this$buffer.equals(other$buffer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Holder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCrchar() ? 79 : 97);
            X $buffer = this.getBuffer();
            result = result * 59 + ($buffer == null ? 43 : $buffer.hashCode());
            return result;
        }

        public String toString() {
            return "ThreadBoundLogOutputStream.Holder(buffer=" + this.getBuffer() + ", crchar=" + this.isCrchar() + ")";
        }

        public Holder(X buffer) {
            this.buffer = buffer;
        }
    }
}

