/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.common.IExecutionServicesRegistration;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcherService;
import com.dtolabs.rundeck.core.execution.orchestrator.OrchestratorService;
import com.dtolabs.rundeck.core.execution.service.FileCopierService;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategyService;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionService;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import java.util.HashMap;

public class BaseFrameworkExecutionServices
implements IExecutionServicesRegistration {
    final HashMap<String, FrameworkSupportService> services = new HashMap();
    private Framework framework;

    public static BaseFrameworkExecutionServices create(Framework framework) {
        BaseFrameworkExecutionServices impl = new BaseFrameworkExecutionServices();
        impl.setFramework(framework);
        return impl;
    }

    @Override
    public FrameworkSupportService getService(String name) {
        return this.services.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setService(String name, FrameworkSupportService service) {
        HashMap<String, FrameworkSupportService> hashMap = this.services;
        synchronized (hashMap) {
            if (null == this.services.get(name) && null != service) {
                this.services.put(name, service);
            } else if (null == service) {
                this.services.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overrideService(String name, FrameworkSupportService service) {
        HashMap<String, FrameworkSupportService> hashMap = this.services;
        synchronized (hashMap) {
            this.services.put(name, service);
        }
    }

    @Override
    public OrchestratorService getOrchestratorService() {
        return OrchestratorService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public WorkflowExecutionService getWorkflowExecutionService() {
        return WorkflowExecutionService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public WorkflowStrategyService getWorkflowStrategyService() {
        return WorkflowStrategyService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public StepExecutionService getStepExecutionService() {
        return StepExecutionService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public FileCopierService getFileCopierService() {
        return FileCopierService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public NodeExecutorService getNodeExecutorService() {
        return NodeExecutorService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public NodeStepExecutionService getNodeStepExecutorService() {
        return NodeStepExecutionService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public NodeDispatcherService getNodeDispatcherService() {
        return NodeDispatcherService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public ResourceModelSourceService getResourceModelSourceService() {
        return ResourceModelSourceService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public ResourceFormatParserService getResourceFormatParserService() {
        return ResourceFormatParserService.getInstanceForFramework(this.getFramework(), this);
    }

    @Override
    public ResourceFormatGeneratorService getResourceFormatGeneratorService() {
        return ResourceFormatGeneratorService.getInstanceForFramework(this.getFramework(), this);
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void setFramework(Framework framework) {
        this.framework = framework;
    }
}

