/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.script;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ScriptfileUtils {
    public static final String SHOULD_ADD_BOM = "file-copier-add-utf8-bom";
    private static Set<File> tempFilesToDelete = Collections.synchronizedSet(new HashSet());

    public static LineEndingStyle lineEndingStyleForNode(INodeEntry node) {
        return LineEndingStyle.forOsFamily(node.getOsFamily());
    }

    public static boolean shouldAddBomForNode(INodeEntry node) {
        if (null != node.getAttributes() && null != node.getAttributes().get(SHOULD_ADD_BOM)) {
            String s = node.getAttributes().get(SHOULD_ADD_BOM);
            return "true".equals(s);
        }
        return false;
    }

    private static void writeStream(InputStream input, FileWriter writer) throws IOException {
        ScriptfileUtils.writeStream(input, writer, LineEndingStyle.LOCAL, false);
    }

    private static void writeStream(InputStream input, FileWriter writer, LineEndingStyle style, boolean addBom) throws IOException {
        try (InputStreamReader inStream = new InputStreamReader(input);){
            ScriptfileUtils.writeReader(inStream, writer, style, addBom);
        }
    }

    private static void writeReader(Reader reader, FileWriter writer) throws IOException {
        ScriptfileUtils.writeReader(reader, writer, LineEndingStyle.LOCAL, false);
    }

    private static void writeReader(Reader reader, FileWriter writer, LineEndingStyle style, boolean addBom) throws IOException {
        String inData;
        String linesep;
        BufferedReader inbuff = new BufferedReader(reader);
        String string = linesep = null == style ? LineEndingStyle.LOCAL.getLineSeparator() : style.getLineSeparator();
        if (addBom && StandardCharsets.UTF_8.aliases().contains(writer.getEncoding()) && style == LineEndingStyle.WINDOWS) {
            writer.write(65279);
        }
        while ((inData = inbuff.readLine()) != null) {
            writer.write(inData);
            writer.write(linesep);
        }
        inbuff.close();
    }

    public static File writeScriptTempfile(Framework framework, Reader source, LineEndingStyle style) throws IOException {
        return ScriptfileUtils.writeScriptTempfile(framework, null, null, source, style);
    }

    public static File writeScriptTempfile(Framework framework, InputStream stream, String source, Reader reader, LineEndingStyle style) throws IOException {
        File scriptfile = ScriptfileUtils.createTempFile(framework);
        ScriptfileUtils.writeScriptFile(stream, source, reader, style, scriptfile);
        return scriptfile;
    }

    public static void writeScriptFile(InputStream stream, String scriptString, Reader reader, LineEndingStyle style, File scriptfile, boolean addBom) throws IOException {
        block8: {
            try (FileWriter writer = new FileWriter(scriptfile);){
                if (null != scriptString) {
                    ScriptfileUtils.writeReader(new StringReader(scriptString), writer, style, addBom);
                    break block8;
                }
                if (null != reader) {
                    ScriptfileUtils.writeReader(reader, writer, style, addBom);
                    break block8;
                }
                if (null != stream) {
                    ScriptfileUtils.writeStream(stream, writer, style, addBom);
                    break block8;
                }
                throw new IllegalArgumentException("no script source argument");
            }
        }
    }

    public static void writeScriptFile(InputStream stream, String scriptString, Reader reader, LineEndingStyle style, File scriptfile) throws IOException {
        ScriptfileUtils.writeScriptFile(stream, scriptString, reader, style, scriptfile, false);
    }

    public static File createTempFile(Framework framework) throws IOException {
        String fileExt = ".tmp";
        if ("windows".equalsIgnoreCase(framework.createFrameworkNode().getOsFamily())) {
            fileExt = ".tmp.bat";
        }
        File dispatch = File.createTempFile("dispatch", fileExt, new File(framework.getProperty("framework.tmp.dir")));
        ScriptfileUtils.registerTempFile(dispatch);
        return dispatch;
    }

    private static void registerTempFile(File file) {
        file.deleteOnExit();
        tempFilesToDelete.add(file);
    }

    public static boolean releaseTempFile(File file) {
        return tempFilesToDelete.remove(file) && file.delete();
    }

    public static void setExecutePermissions(File scriptfile) throws IOException {
        if (!scriptfile.setExecutable(true, true)) {
            System.err.println("Unable to set executable bit on temp script file, execution may fail: " + scriptfile.getAbsolutePath());
        }
    }

    public static enum LineEndingStyle {
        UNIX,
        WINDOWS,
        LOCAL;


        public static LineEndingStyle forOsFamily(String family) {
            if (null != family) {
                try {
                    return LineEndingStyle.valueOf(family.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return LOCAL;
        }

        public String getLineSeparator() {
            switch (this) {
                case UNIX: {
                    return "\n";
                }
                case WINDOWS: {
                    return "\r\n";
                }
            }
            return System.getProperty("line.separator");
        }
    }
}

