/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MutableDataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.service.ScriptOptionValues;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.utils.MapData;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import com.dtolabs.rundeck.plugins.user.groups.UserGroupSourcePlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUserGroupSource
extends BaseScriptPlugin
implements UserGroupSourcePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptOptionValues.class);
    private static final String START_MARKER = "==START_GROUPS==";
    private static final String END_MARKER = "==END_GROUPS==";
    private static final String USERNAME = "username";
    private final ServiceProviderLoader pluginManager;

    public ScriptUserGroupSource(ScriptPluginProvider provider, ServiceProviderLoader pluginManager) {
        super(provider);
        this.pluginManager = pluginManager;
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    @Override
    public List<String> getGroups(String username, Map<String, Object> config) {
        ArrayList<String> groups;
        block11: {
            MutableDataContext dataContext = DataContextUtils.context("config", MapData.toStringStringMap(config));
            HashMap<String, String> usernameConfigMap = new HashMap<String, String>();
            usernameConfigMap.put(USERNAME, username);
            dataContext.put("session", usernameConfigMap);
            DataContext ctx = this.createScriptDataContext(dataContext.getData());
            ExecArgList scriptArgsList = this.createScriptArgsList(ctx);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errStream = new ByteArrayOutputStream();
            groups = new ArrayList<String>();
            int result = -1;
            try {
                result = ScriptExecUtil.runLocalCommand(System.getProperty("os.name").toLowerCase(), scriptArgsList, ctx, null, outStream, errStream);
                if (result == 0) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outStream.toByteArray())));){
                        boolean started = false;
                        boolean ended = false;
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith("#")) continue;
                            if (line.equals(START_MARKER)) {
                                started = true;
                                continue;
                            }
                            if (line.equals(END_MARKER)) {
                                ended = true;
                                continue;
                            }
                            if (!started || ended) continue;
                            groups.add(line);
                        }
                        break block11;
                    }
                }
                LOG.error(new String(errStream.toByteArray()));
            }
            catch (Exception ex) {
                LOG.error("UserGroupSource plugin: " + this.getProvider().getName() + " failed", (Throwable)ex);
            }
        }
        return groups;
    }
}

