/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.execution.Contextual;
import com.dtolabs.rundeck.core.execution.ExecutionLogger;
import com.dtolabs.rundeck.core.execution.workflow.ContextLogger;
import com.dtolabs.rundeck.core.logging.LogLevel;
import java.util.HashMap;
import java.util.Map;

public class LoggerWithContext
implements ExecutionLogger {
    ContextLogger contextLogger;
    Contextual contextual;

    public LoggerWithContext(ContextLogger contextLogger, Contextual contextual) {
        this.contextLogger = contextLogger;
        this.contextual = contextual;
    }

    @Override
    public final void log(int level, String message) {
        this.logInternal(level, message, this.contextual.getContext());
    }

    @Override
    public void log(int level, String message, Map eventMeta) {
        this.logInternal(level, message, this.mergeMap(eventMeta, this.contextual.getContext()));
    }

    private Map<String, String> mergeMap(Map a, Map<String, String> b) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (null != a) {
            for (Object k : a.keySet()) {
                hashMap.put(k.toString(), a.get(k).toString());
            }
        }
        if (null != b) {
            hashMap.putAll(b);
        }
        return hashMap;
    }

    @Override
    public void event(String eventType, String message, Map eventMeta) {
        this.contextLogger.emit(eventType, LogLevel.NORMAL, message, this.mergeMap(eventMeta, this.contextual.getContext()));
    }

    public void logInternal(int level, String message, Map<String, String> data) {
        if (level >= 4) {
            this.contextLogger.verbose(message, data);
        } else if (level >= 3) {
            this.contextLogger.verbose(message, data);
        } else if (level >= 2) {
            this.contextLogger.log(message, data);
        } else if (level >= 1) {
            this.contextLogger.warn(message, data);
        } else if (level >= 0) {
            this.contextLogger.error(message, data);
        } else {
            this.contextLogger.log(message, data);
        }
    }
}

