/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.jobs;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionLogger;
import com.dtolabs.rundeck.core.execution.ExecutionReference;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.jobs.JobEventResult;
import com.dtolabs.rundeck.core.jobs.JobExecutionEvent;
import java.util.Map;

public class JobExecutionEventImpl
implements JobExecutionEvent {
    private StepExecutionContext executionContext;
    ExecutionReference execution;
    JobEventResult result;
    WorkflowExecutionItem workflow;

    public JobExecutionEventImpl(StepExecutionContext executionContext) {
        if (executionContext != null) {
            this.executionContext = ExecutionContextImpl.builder(executionContext).build();
        }
    }

    private JobExecutionEventImpl(StepExecutionContext executionContext, ExecutionReference execution, WorkflowExecutionItem workflow) {
        this.executionContext = ExecutionContextImpl.builder(executionContext).build();
        this.execution = execution;
        this.workflow = workflow;
    }

    public static JobExecutionEvent beforeRun(StepExecutionContext executionContext, ExecutionReference execution, WorkflowExecutionItem workflow) {
        return new JobExecutionEventImpl(executionContext, execution, workflow);
    }

    private JobExecutionEventImpl(StepExecutionContext executionContext, ExecutionReference execution, JobEventResult result) {
        this.executionContext = ExecutionContextImpl.builder(executionContext).build();
        this.execution = execution;
        this.result = result;
    }

    public static JobExecutionEvent afterRun(StepExecutionContext executionContext, ExecutionReference execution, JobEventResult result) {
        return new JobExecutionEventImpl(executionContext, execution, result);
    }

    @Override
    public String getProjectName() {
        if (this.executionContext != null) {
            return this.executionContext.getFrameworkProject();
        }
        return null;
    }

    @Override
    public Map<String, String> getOptions() {
        if (this.executionContext != null && this.executionContext.getDataContext() != null && !this.executionContext.getDataContext().isEmpty() && this.executionContext.getDataContext().containsKey("option")) {
            return this.executionContext.getDataContext().get("option");
        }
        return null;
    }

    @Override
    public ExecutionLogger getExecutionLogger() {
        if (this.executionContext != null) {
            return this.executionContext.getExecutionLogger();
        }
        return null;
    }

    @Override
    public String getUserName() {
        if (this.executionContext != null && this.executionContext.getDataContext() != null && !this.executionContext.getDataContext().isEmpty() && this.executionContext.getDataContext().containsKey("job")) {
            return this.executionContext.getDataContext().get("job").get("user.name");
        }
        return null;
    }

    @Override
    public String getExecutionId() {
        if (this.executionContext != null && this.executionContext.getDataContext() != null && !this.executionContext.getDataContext().isEmpty() && this.executionContext.getDataContext().containsKey("job")) {
            return this.executionContext.getDataContext().get("job").get("execid");
        }
        return null;
    }

    @Override
    public INodeSet getNodes() {
        if (this.executionContext != null) {
            return this.executionContext.getNodes();
        }
        return null;
    }

    @Override
    public StepExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(StepExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public ExecutionReference getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionReference execution) {
        this.execution = execution;
    }

    @Override
    public JobEventResult getResult() {
        return this.result;
    }

    public void setResult(JobEventResult result) {
        this.result = result;
    }

    @Override
    public WorkflowExecutionItem getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(WorkflowExecutionItem workflow) {
        this.workflow = workflow;
    }
}

