/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.acl;

import com.dtolabs.rundeck.core.authorization.providers.ValidatorFactory;
import com.dtolabs.rundeck.core.storage.StorageManager;
import java.util.function.Function;
import org.rundeck.app.acl.ACLFileManager;
import org.rundeck.app.acl.ACLStorageFileManager;
import org.rundeck.app.acl.AppACLContext;
import org.rundeck.app.acl.BaseContextACLManager;
import org.rundeck.app.acl.ContextACLManager;
import org.rundeck.app.acl.ListenableACLFileManager;

public class ContextACLStorageFileManager
extends BaseContextACLManager<AppACLContext>
implements ContextACLManager<AppACLContext> {
    private final StorageManager storageManager;
    private final ValidatorFactory validatorFactory;
    private final Function<AppACLContext, String> prefixMapping;

    @Override
    protected ACLFileManager createManager(AppACLContext context) {
        return new ListenableACLFileManager(ACLStorageFileManager.builder().validator(context.isSystem() ? this.validatorFactory.create() : this.validatorFactory.forProjectOnly(context.getProject())).storage(this.storageManager).prefix(this.prefixMapping.apply(context)).build());
    }

    public static ContextACLStorageFileManagerBuilder builder() {
        return new ContextACLStorageFileManagerBuilder();
    }

    public ContextACLStorageFileManager(StorageManager storageManager, ValidatorFactory validatorFactory, Function<AppACLContext, String> prefixMapping) {
        this.storageManager = storageManager;
        this.validatorFactory = validatorFactory;
        this.prefixMapping = prefixMapping;
    }

    public static class ContextACLStorageFileManagerBuilder {
        private StorageManager storageManager;
        private ValidatorFactory validatorFactory;
        private Function<AppACLContext, String> prefixMapping;

        ContextACLStorageFileManagerBuilder() {
        }

        public ContextACLStorageFileManagerBuilder storageManager(StorageManager storageManager) {
            this.storageManager = storageManager;
            return this;
        }

        public ContextACLStorageFileManagerBuilder validatorFactory(ValidatorFactory validatorFactory) {
            this.validatorFactory = validatorFactory;
            return this;
        }

        public ContextACLStorageFileManagerBuilder prefixMapping(Function<AppACLContext, String> prefixMapping) {
            this.prefixMapping = prefixMapping;
            return this;
        }

        public ContextACLStorageFileManager build() {
            return new ContextACLStorageFileManager(this.storageManager, this.validatorFactory, this.prefixMapping);
        }

        public String toString() {
            return "ContextACLStorageFileManager.ContextACLStorageFileManagerBuilder(storageManager=" + this.storageManager + ", validatorFactory=" + this.validatorFactory + ", prefixMapping=" + this.prefixMapping + ")";
        }
    }
}

