/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CustomFieldsAdapter {
    Description description;
    Set<String> dynamicFormProperties = new HashSet<String>();
    Map<String, CustomFields> tempCustomFields = new HashMap<String, CustomFields>();

    public static CustomFieldsAdapter create(Description description) {
        return new CustomFieldsAdapter(description);
    }

    private CustomFieldsAdapter(Description description) {
        this.description = description;
        if (description != null) {
            this.dynamicFormProperties = description.getProperties().stream().filter(CustomFieldsAdapter::isDynamicFormProperty).map(Property::getName).collect(Collectors.toCollection(HashSet::new));
        }
    }

    private static boolean isDynamicFormProperty(Property p) {
        Object displayType = p.getRenderingOptions().get("displayType");
        return StringRenderingConstants.DisplayType.DYNAMIC_FORM.equals(displayType) || "DYNAMIC_FORM".equals(displayType);
    }

    public static String replaceConvertedCustomFieldValues(CustomFields customFields, Map<String, String> converted) {
        customFields.update(converted);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(customFields.fields);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static CustomFields convertJsonCustomFieldValues(String input) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List list = (List)objectMapper.readValue(input, (TypeReference)new TypeReference<List<CustomField>>(){});
            return new CustomFields(list);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public Object convertInput(String key, Object input) {
        if (this.isDynamicFormProperty(key).booleanValue() && input instanceof String) {
            CustomFields o = CustomFieldsAdapter.convertJsonCustomFieldValues((String)input);
            if (o == null) {
                return input;
            }
            this.tempCustomFields.put(key, o);
            return o.keyedValues;
        }
        return input;
    }

    public Object convertOutput(String key, Object output) {
        if (this.isDynamicFormProperty(key).booleanValue() && output instanceof Map && this.tempCustomFields.containsKey(key)) {
            return CustomFieldsAdapter.replaceConvertedCustomFieldValues(this.tempCustomFields.get(key), (Map)output);
        }
        return output;
    }

    private Boolean isDynamicFormProperty(String key) {
        return this.dynamicFormProperties.contains(key);
    }

    public static class CustomFields {
        Map<String, String> keyedValues = new HashMap<String, String>();
        List<CustomField> fields;

        public CustomFields(List<CustomField> fields) {
            this.fields = fields;
            this.fields.forEach(f -> this.keyedValues.put(f.getKey(), f.getValue()));
        }

        public void update(Map<String, String> converted) {
            this.fields.forEach(f -> f.setValue((String)converted.get(f.getKey())));
        }
    }

    public static class CustomField {
        private String key;
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        private String label;
        private String value;
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        private String desc;

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomField)) {
                return false;
            }
            CustomField other = (CustomField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            return result;
        }

        public String toString() {
            return "CustomFieldsAdapter.CustomField(key=" + this.getKey() + ", label=" + this.getLabel() + ", value=" + this.getValue() + ", desc=" + this.getDesc() + ")";
        }
    }
}

