/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.NodeEntryFactory;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeFileParser;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class NodesYamlParser
implements NodeFileParser {
    private File file;
    private InputStream inputStream;
    private NodeReceiver nodes;

    public NodesYamlParser(File file, NodeReceiver nodes) {
        this.file = file;
        this.nodes = nodes;
    }

    public NodesYamlParser(InputStream inputStream, NodeReceiver nodes) {
        this.inputStream = inputStream;
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws NodeFileParserException {
        if (null == this.file && null == this.inputStream) {
            throw new NullPointerException("file or inputStream was not set");
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        try (InputStreamReader reader = null != this.file ? new FileReader(this.file) : new InputStreamReader(this.inputStream);){
            for (Object o : yaml.loadAll((Reader)reader)) {
                Object map;
                if (o instanceof Map) {
                    map = (Map)o;
                    for (Map.Entry entry : map.entrySet()) {
                        NodeEntryImpl iNodeEntry;
                        String nodename = (String)entry.getKey();
                        if (null == entry.getValue()) {
                            throw new NodeFileParserException("Empty node entry for: " + nodename);
                        }
                        if (!(entry.getValue() instanceof Map)) {
                            throw new NodeFileParserException("Expected map data for node entry '" + nodename + "', but saw: " + ((Map)entry.getValue()).getClass().getName());
                        }
                        HashMap<String, Object> newmap = new HashMap<String, Object>((Map)entry.getValue());
                        newmap.put("nodename", nodename);
                        try {
                            iNodeEntry = NodeEntryFactory.createFromMap(newmap);
                        }
                        catch (IllegalArgumentException e) {
                            throw new NodeFileParserException(e);
                        }
                        this.nodes.putNode(iNodeEntry);
                    }
                    continue;
                }
                if (!(o instanceof Collection)) continue;
                map = (Collection)o;
                Iterator iterator = map.iterator();
                while (iterator.hasNext()) {
                    NodeEntryImpl iNodeEntry;
                    Map nodemap = (Map)((Object)iterator.next());
                    try {
                        iNodeEntry = NodeEntryFactory.createFromMap(nodemap);
                    }
                    catch (IllegalArgumentException e) {
                        throw new NodeFileParserException(e);
                    }
                    this.nodes.putNode(iNodeEntry);
                }
            }
        }
        catch (NodeFileParserException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new NodeFileParserException(e);
        }
        catch (Exception e) {
            throw new NodeFileParserException(e);
        }
    }
}

