/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.common;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.data.BaseDataContext;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.FileCopierUtil;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.RandomStringUtils;

public class DefaultFileCopierUtil
implements FileCopierUtil {
    public static final String FILE_COPY_DESTINATION_DIR = "file-copy-destination-dir";
    public static final String FRAMEWORK_FILE_COPY_DESTINATION_DIR = "framework.file-copy-destination-dir";
    public static final String PROJECT_FILE_COPY_DESTINATION_DIR = "project.file-copy-destination-dir";
    public static final String DEFAULT_WINDOWS_FILE_EXT = ".bat";
    public static final String DEFAULT_UNIX_FILE_EXT = ".sh";
    private static AtomicLong counter = new AtomicLong(0L);

    @Override
    public File writeScriptTempFile(ExecutionContext context, File original, InputStream input, String script, INodeEntry node, boolean expandTokens) throws FileCopierException {
        return this.writeScriptTempFile(context, original, input, script, node, null, expandTokens);
    }

    @Override
    public File writeScriptTempFile(ExecutionContext context, File original, InputStream input, String script, INodeEntry node, File destination, boolean expandTokens) throws FileCopierException {
        File tempfile;
        block22: {
            Framework framework = context.getFramework();
            WFSharedContext sharedContext = new WFSharedContext(context.getSharedDataContext());
            sharedContext.merge(ContextView.node(node.getNodename()), new BaseDataContext("node", DataContextUtils.nodeData(node)));
            ScriptfileUtils.LineEndingStyle style = ScriptfileUtils.lineEndingStyleForNode(node);
            boolean addBom = false;
            if (style == ScriptfileUtils.LineEndingStyle.WINDOWS) {
                addBom = ScriptfileUtils.shouldAddBomForNode(node);
            }
            try {
                tempfile = null == destination ? ScriptfileUtils.createTempFile(framework) : destination;
                if (null != original) {
                    try (FileInputStream in = new FileInputStream(original);
                         FileOutputStream out = new FileOutputStream(tempfile);){
                        Streams.copyStream(in, out);
                        break block22;
                    }
                }
                if (null != script) {
                    if (expandTokens) {
                        SharedDataContextUtils.replaceTokensInScript(script, sharedContext, style, tempfile, node.getNodename(), addBom);
                    } else {
                        ScriptfileUtils.writeScriptFile(null, script, null, style, tempfile, addBom);
                    }
                    break block22;
                }
                if (null != input) {
                    if (expandTokens) {
                        SharedDataContextUtils.replaceTokensInStream(input, sharedContext, style, tempfile, node.getNodename(), addBom);
                    } else {
                        ScriptfileUtils.writeScriptFile(input, null, null, style, tempfile, addBom);
                    }
                    break block22;
                }
                return null;
            }
            catch (IOException e) {
                throw new FileCopierException("error writing script to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
            }
        }
        try {
            ScriptfileUtils.setExecutePermissions(tempfile);
        }
        catch (IOException e) {
            System.err.println("Failed to set execute permissions on tempfile, execution may fail: " + tempfile.getAbsolutePath());
        }
        return tempfile;
    }

    @Override
    public String defaultRemoteFileExtensionForNode(INodeEntry node) {
        if (null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim())) {
            return DEFAULT_WINDOWS_FILE_EXT;
        }
        return DEFAULT_UNIX_FILE_EXT;
    }

    @Override
    public String appendRemoteFileExtension(String filepath, String fileext) {
        if (null == fileext) {
            return filepath;
        }
        Object result = filepath;
        Object ext = fileext;
        if (!((String)ext).startsWith(".")) {
            ext = "." + fileext;
        }
        result = (String)result + (String)(filepath.endsWith((String)ext) ? "" : ext);
        return result;
    }

    @Override
    public String getRemoteDirForNode(INodeEntry node) {
        String pathSeparator = "/";
        String remotedir = "/tmp/";
        if (null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim())) {
            pathSeparator = "\\";
            remotedir = "C:\\WINDOWS\\TEMP\\";
        }
        if (null != node.getAttributes() && null != node.getAttributes().get(FILE_COPY_DESTINATION_DIR)) {
            String s = node.getAttributes().get(FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        return remotedir;
    }

    @Override
    public String getRemoteDirForNode(INodeEntry node, IRundeckProject project, IFramework framework) {
        String osfamily;
        String pathSeparator = "/";
        String remotedir = "/tmp/";
        String string = osfamily = null != node.getOsFamily() ? node.getOsFamily().trim().toLowerCase() : "unix";
        if ("windows".equalsIgnoreCase(osfamily)) {
            pathSeparator = "\\";
            remotedir = "C:\\WINDOWS\\TEMP\\";
        }
        if (null != node.getAttributes() && null != node.getAttributes().get(FILE_COPY_DESTINATION_DIR)) {
            String s = node.getAttributes().get(FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != project && project.hasProperty("project.file-copy-destination-dir." + osfamily)) {
            String s = project.getProperty("project.file-copy-destination-dir." + osfamily);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != project && project.hasProperty(PROJECT_FILE_COPY_DESTINATION_DIR)) {
            String s = project.getProperty(PROJECT_FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != framework && framework.getPropertyLookup().hasProperty("framework.file-copy-destination-dir." + osfamily)) {
            String s = framework.getPropertyLookup().getProperty("framework.file-copy-destination-dir." + osfamily);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != framework && framework.getPropertyLookup().hasProperty(FRAMEWORK_FILE_COPY_DESTINATION_DIR)) {
            String s = framework.getPropertyLookup().getProperty(FRAMEWORK_FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        return remotedir;
    }

    @Override
    public String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName) {
        return this.generateRemoteFilepathForNode(node, scriptfileName, null);
    }

    @Override
    public String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName, String fileExtension) {
        return this.generateRemoteFilepathForNode(node, scriptfileName, fileExtension, null);
    }

    @Override
    public String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName, String fileExtension, String identity) {
        return this.generateRemoteFilepathForNode(node, null, null, scriptfileName, fileExtension, identity);
    }

    @Override
    public String generateRemoteFilepathForNode(INodeEntry node, IRundeckProject project, IFramework framework, String scriptfileName, String fileExtension, String identity) {
        String tempfilename = String.format("%d-%s-%s-%s", counter.getAndIncrement(), identity != null ? identity : RandomStringUtils.randomAlphanumeric((int)10), node.getNodename(), scriptfileName);
        String extension = fileExtension;
        if (null == extension) {
            extension = this.defaultRemoteFileExtensionForNode(node);
        }
        String remoteFilename = this.appendRemoteFileExtension(this.cleanFileName(tempfilename), null != extension ? this.cleanFileName(extension) : null);
        String remotedir = this.getRemoteDirForNode(node, project, framework);
        return remotedir + remoteFilename;
    }

    private String cleanFileName(String nodename) {
        return nodename.replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    @Override
    public File writeTempFile(ExecutionContext context, File original, InputStream input, String script) throws FileCopierException {
        File tempfile = null;
        try {
            tempfile = ScriptfileUtils.createTempFile(context.getFramework());
        }
        catch (IOException e) {
            throw new FileCopierException("error writing to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
        }
        return this.writeLocalFile(original, input, script, tempfile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public File writeLocalFile(File original, InputStream input, String script, File destinationFile) throws FileCopierException {
        try {
            if (null != original) {
                if (original.isDirectory()) {
                    FileUtils.copyDirectory(original, destinationFile);
                    return destinationFile;
                }
                File destinationFolder = destinationFile.getParentFile();
                if (null != destinationFolder && !destinationFolder.exists()) {
                    destinationFolder.mkdirs();
                }
                try (FileInputStream in = new FileInputStream(original);
                     FileOutputStream out = new FileOutputStream(destinationFile);){
                    Streams.copyStream(in, out);
                    return destinationFile;
                }
            }
            if (null != input) {
                try (FileOutputStream out = new FileOutputStream(destinationFile);){
                    Streams.copyStream(input, out);
                    return destinationFile;
                }
            }
            if (null == script) return destinationFile;
            StringReader in = new StringReader(script);
            try (OutputStreamWriter write = new OutputStreamWriter(new FileOutputStream(destinationFile));){
                Streams.copyWriterCount(in, write);
                return destinationFile;
            }
        }
        catch (IOException | SecurityException e) {
            throw new FileCopierException("error writing to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
        }
    }
}

