/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ScriptPluginNodeExecutor
extends BaseScriptPlugin
implements NodeExecutor {
    public ScriptPluginNodeExecutor(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    @Override
    public boolean isUseConventionalPropertiesMapping() {
        return true;
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        try {
            ScriptPluginNodeExecutor.createDescription(plugin, true, DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext executionContext, String[] command, INodeEntry node) {
        return this.executeCommand(executionContext, command, node, true);
    }

    public NodeExecutorResult executeCommand(ExecutionContext executionContext, String[] command, INodeEntry node, boolean showError) {
        Map<String, Map<String, String>> finalDataContext;
        Description pluginDesc = this.getDescription();
        ScriptPluginProvider plugin = this.getProvider();
        String pluginname = plugin.getName();
        executionContext.getExecutionListener().log(3, "[" + pluginname + "] execCommand started, command: " + StringArrayUtil.asString(command, " "));
        DataContext localDataContext = this.createScriptDataContext(executionContext.getFramework(), executionContext.getFrameworkProject(), executionContext.getDataContext());
        HashMap<String, String> scptexec = new HashMap<String, String>();
        scptexec.put("command", StringArrayUtil.asString(command, " "));
        localDataContext.put("exec", scptexec);
        Map<String, Map<String, String>> nodeExecContext = DataContextUtils.addContext("exec", scptexec, null);
        if (executionContext.getPrivateDataContext() != null) {
            localDataContext.put("private", executionContext.getPrivateDataContext().get("option"));
        }
        try {
            finalDataContext = this.loadConfigData(executionContext, this.loadInstanceDataFromNodeAttributes(node, pluginDesc), localDataContext, pluginDesc, "NodeExecutor");
        }
        catch (ConfigurationException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, "[" + pluginname + "] " + e.getMessage(), e, node, -1);
        }
        ExecArgList execArgList = this.createScriptArgsList(nodeExecContext);
        String localNodeOsFamily = this.getFramework().createFrameworkNode().getOsFamily();
        executionContext.getExecutionListener().log(3, "[" + this.getProvider().getName() + "] executing: " + Arrays.asList(execArgList));
        int result = -1;
        try {
            result = this.getScriptExecHelper().runLocalCommand(localNodeOsFamily, execArgList, finalDataContext, null, System.out, System.err);
            executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result code: " + result + ", success: " + (0 == result));
            if (null != executionContext.getOutputContext()) {
                executionContext.getOutputContext().addOutput("exec", "exitCode", String.valueOf(result));
            }
            if (0 != result) {
                return NodeExecutorResultImpl.createFailure(NodeStepFailureReason.NonZeroResultCode, "[" + pluginname + "] Result code: " + result, node, result);
            }
            return NodeExecutorResultImpl.createSuccess(node);
        }
        catch (IOException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.IOFailure, "[" + pluginname + "] " + e.getMessage(), e, node, result);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NodeExecutorResultImpl.createFailure(StepFailureReason.Interrupted, "[" + pluginname + "] " + e.getMessage(), e, node, result);
        }
    }
}

