/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging.internal;

import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.LogLevel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DefaultLogEvent
implements LogEvent {
    private LogLevel loglevel;
    private Date datetime;
    private String message;
    private String eventType;
    private Map<String, String> metadata;

    public DefaultLogEvent() {
    }

    public DefaultLogEvent(LogLevel loglevel, Date datetime, String message, String eventType, Map<String, String> metadata) {
        this.loglevel = loglevel;
        this.datetime = datetime;
        this.message = message;
        this.eventType = eventType;
        this.metadata = metadata;
    }

    public DefaultLogEvent(LogEvent event) {
        this(event, new HashMap<String, String>());
    }

    public DefaultLogEvent(LogEvent event, Map<String, String> defaultMetadata) {
        this.loglevel = event.getLoglevel();
        this.datetime = event.getDatetime();
        this.message = event.getMessage();
        this.eventType = event.getEventType();
        this.metadata = new HashMap<String, String>(defaultMetadata);
        if (event.getMetadata() != null) {
            this.metadata.putAll(event.getMetadata());
        }
    }

    static DefaultLogEvent with(LogEvent event, Map<String, String> metadata) {
        return new DefaultLogEvent(event, metadata);
    }

    public String toString() {
        return "DefaultLogEvent{, eventType=" + this.eventType + ", loglevel=" + this.loglevel + ", datetime=" + this.datetime + ", message='" + this.message + "', metadata=" + this.metadata + "}";
    }

    @Override
    public LogLevel getLoglevel() {
        return this.loglevel;
    }

    public void setLoglevel(LogLevel loglevel) {
        this.loglevel = loglevel;
    }

    @Override
    public Date getDatetime() {
        return this.datetime;
    }

    public void setDatetime(Date datetime) {
        this.datetime = datetime;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }
}

