/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging.internal;

import com.dtolabs.rundeck.core.execution.Contextual;
import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.LogLevel;
import com.dtolabs.rundeck.core.logging.internal.LogEventBuffer;
import com.dtolabs.rundeck.core.utils.LogBufferManager;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public class LogEventBufferManager
implements LogBufferManager<LogEvent, LogEventBuffer> {
    Set<LogEventBuffer> buffers = new TreeSet<LogEventBuffer>();
    Charset charset;
    Contextual listener;
    LogLevel level;

    public LogEventBufferManager() {
    }

    public LogEventBufferManager(LogLevel level, Contextual listener, Charset charset) {
        this.charset = charset;
        this.listener = listener;
        this.level = level;
    }

    @Override
    public LogEventBuffer create(Charset charset) {
        LogEventBuffer buffer = new LogEventBuffer(this.level, this.listener, charset != null ? charset : this.charset);
        this.buffers.add(buffer);
        return buffer;
    }

    public static LogEventBufferManager createManager(LogLevel level, Contextual listener, Charset charset) {
        return new LogEventBufferManager(level, listener, charset);
    }

    @Override
    public void flush(Consumer<LogEvent> writer) {
        for (LogEventBuffer b : this.buffers) {
            if (!b.isEmpty()) {
                writer.accept(b.get());
            }
            b.clear();
        }
        this.buffers.clear();
    }
}

