/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.Rule;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.States;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class BaseRuleEngine
implements RuleEngine {
    private Set<Rule> ruleSet;

    public BaseRuleEngine(Set<Rule> ruleSet) {
        this.ruleSet = new HashSet<Rule>(ruleSet);
    }

    @Override
    public Set<Rule> getRuleSet() {
        return this.ruleSet;
    }

    @Override
    public void addRule(Rule rule) {
        this.ruleSet.add(rule);
    }

    @Override
    public StateObj evaluateRules(StateObj state) {
        MutableStateObj dataState = States.mutable();
        this.getRuleSet().stream().filter(i -> i.test(state)).map(input -> Optional.ofNullable(input.evaluate(state))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).forEach(dataState::updateState);
        return dataState;
    }

    public String toString() {
        return "RuleEngine{ruleSet=" + this.ruleSet + "}";
    }
}

