/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.LogBufferManager;
import com.dtolabs.rundeck.core.utils.StringLogBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class StringLogManager
implements LogBufferManager<String, StringLogBuffer> {
    private List<StringLogBuffer> buffers = new ArrayList<StringLogBuffer>();
    private Charset charset;

    public StringLogManager(Charset charset) {
        this.charset = charset;
    }

    @Override
    public StringLogBuffer create(Charset charset) {
        StringLogBuffer buffer = new StringLogBuffer(charset != null ? charset : this.charset);
        this.buffers.add(buffer);
        return buffer;
    }

    @Override
    public void flush(Consumer<String> writer) {
        for (StringLogBuffer buffer : this.buffers) {
            writer.accept(buffer.get());
            buffer.clear();
        }
        this.buffers.clear();
    }

    public static StringLogManager factory(Charset charset) {
        return new StringLogManager(charset);
    }
}

